% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CVST_linkfunction.R
\name{pred_krr}
\alias{pred_krr}
\title{Predict responses for new data using fitted KRR model}
\usage{
pred_krr(model, newdata)
}
\arguments{
\item{model}{A fitted KRR model object returned by \code{\link{fastkrr}}.}

\item{newdata}{New design matrix or data frame containing new observations
for which predictions are to be made.}
}
\value{
A numeric vector of predicted values corresponding to 'newdata'.
}
\description{
`pred_krr()` generates predictions from a fitted Kernel Ridge Regression (KRR) model
for new data.
}
\details{
The kernel matrix between training data and new data is explicitly
computed using \code{\link{make_kernel}}, and predictions are obtained by
multiplying this kernel matrix with the fitted coefficients.

Mathematically, predictions are given by
\deqn{\hat{y}_{new} = K_{new} \hat{\alpha}}
where \eqn{K_{new}} is the kernel matrix and \eqn{\hat{\alpha}} are the estimated coefficients.
}
\examples{
# Fitting model: pivoted
n = 30
d = 1
X = matrix(runif(n*d, 0, 1), nrow = n, ncol = d)
y = as.vector(sin(2*pi*rowMeans(X)^3) + rnorm(n, 0, 0.1))
lambda = 1e-4
rho = 1
model = fastkrr(X, y, kernel = "gaussian", rho = rho, lambda = lambda, opt = "pivoted")

# Predict
new_n = 50
new_x = matrix(runif(new_n*d, 0, 1), nrow = new_n, ncol = d)
new_y = as.vector(sin(2*pi*rowMeans(new_x)^3) + rnorm(new_n, 0, 0.1))

pred = pred_krr(model, new_x)
crossprod(pred, new_y) / new_n
}
\seealso{
\code{\link{fastkrr}}, \code{\link{make_kernel}}
}
