# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Huber mean estimation
#' @description Internal function implemented in C++ for tuning-free Huber mean estimation. This function is incorporated into \code{farm.mean}.
#' @param X An \eqn{n}-dimensional data vector.
#' @param n The length of \code{X}.
#' @param epsilon An \strong{optional} numerical value for tolerance level. The default value is 0.0001.
#' @param iteMax An \strong{optional} integer for maximun number of iteration. The default value is 500.
#' @seealso \code{\link{farm.mean}}
huberMean <- function(X, n, epsilon = 0.0001, iteMax = 500L) {
    .Call('_FarmTest_huberMean', PACKAGE = 'FarmTest', X, n, epsilon, iteMax)
}

#' @title Huber-type covariance estimation
#' @description Internal function implemented in C++ for tuning-free Huber-type covariance estimation. This function is incorporated into \code{farm.cov}.
#' @param X An \eqn{n} by \eqn{p} data matrix.
#' @param n Number of rows of \code{X}.
#' @param p Number of columns of \code{X}.
#' @seealso \code{\link{farm.cov}}
huberCov <- function(X, n, p) {
    .Call('_FarmTest_huberCov', PACKAGE = 'FarmTest', X, n, p)
}

#' @title Multiple testing via an adaptive Benjamini-Hochberg procedure
#' @description Internal function implemented in C++ for an adaptive Benjamini-Hochberg procedure. This function is incorporated into \code{farm.fdr}.
#' @param Prob A sequence of p-values. Each entry of \code{Prob} must be between 0 and 1.
#' @param alpha A numerical value for controlling the false discovery rate. The value of \code{alpha} must be strictly between 0 and 1.
#' @param p The length of \code{Prob}.
#' @seealso \code{\link{farm.fdr}}
getRej <- function(Prob, alpha, p) {
    .Call('_FarmTest_getRej', PACKAGE = 'FarmTest', Prob, alpha, p)
}

#' @title Robust multiple testing
#' @description Internal function implemented in C++ for robust multiple testing without factor-adjustment. This case is incorporated into \code{farm.test}.
#' @param X An \eqn{n} by \eqn{p} data matrix with each row being a sample.
#' @param h0 A \eqn{p}-vector of true means.
#' @param alpha An \strong{optional} level for controlling the false discovery rate. The value of \code{alpha} must be between 0 and 1. The default value is 0.05.
#' @param alternative An \strong{optional} character string specifying the alternate hypothesis, must be one of "two.sided" (default), "less" or "greater".
#' @seealso \code{\link{farm.test}}
rmTest <- function(X, h0, alpha = 0.05, alternative = "two.sided") {
    .Call('_FarmTest_rmTest', PACKAGE = 'FarmTest', X, h0, alpha, alternative)
}

#' @title Robust multiple testing with multiplier bootstrap
#' @description Internal function implemented in C++ for robust multiple testing without factor-adjustment, where p-values are obtained via multiplier bootstrap. 
#' This case is incorporated into \code{farm.test}.
#' @param X An \eqn{n} by \eqn{p} data matrix with each row being a sample.
#' @param h0 A \eqn{p}-vector of true means.
#' @param alpha An \strong{optional} level for controlling the false discovery rate. The value of \code{alpha} must be between 0 and 1. The default value is 0.05.
#' @param alternative An \strong{optional} character string specifying the alternate hypothesis, must be one of "two.sided" (default), "less" or "greater".
#' @param B An \strong{optional} positive integer specifying the size of bootstrap sample. The dafault value is 500.
#' @seealso \code{\link{farm.test}}
rmTestBoot <- function(X, h0, alpha = 0.05, alternative = "two.sided", B = 500L) {
    .Call('_FarmTest_rmTestBoot', PACKAGE = 'FarmTest', X, h0, alpha, alternative, B)
}

#' @title Two sample robust multiple testing
#' @description Internal function implemented in C++ for two sample robust multiple testing without factor-adjustment. This case is incorporated into \code{farm.test}.
#' @param X An \eqn{nX} by \eqn{p} data matrix with each row being a sample.
#' @param Y An \eqn{nY} by \eqn{p} data matrix with each row being a sample. The number of columns of \code{X} and \code{Y} must be the same.
#' @param h0 A \eqn{p}-vector of true difference in means.
#' @param alpha An \strong{optional} level for controlling the false discovery rate. The value of \code{alpha} must be between 0 and 1. The default value is 0.05.
#' @param alternative An \strong{optional} character string specifying the alternate hypothesis, must be one of "two.sided" (default), "less" or "greater".
#' @seealso \code{\link{farm.test}}
rmTestTwo <- function(X, Y, h0, alpha = 0.05, alternative = "two.sided") {
    .Call('_FarmTest_rmTestTwo', PACKAGE = 'FarmTest', X, Y, h0, alpha, alternative)
}

#' @title Two sample robust multiple testing with multiplier bootstrap
#' @description Internal function implemented in C++ for two sample robust multiple testing without factor-adjustment, where p-values are obtained via multiplier bootstrap. 
#' This case is incorporated into \code{farm.test}.
#' @param X An \eqn{nX} by \eqn{p} data matrix with each row being a sample.
#' @param Y An \eqn{nY} by \eqn{p} data matrix with each row being a sample. The number of columns of \code{X} and \code{Y} must be the same.
#' @param h0 A \eqn{p}-vector of true difference in means.
#' @param alpha An \strong{optional} level for controlling the false discovery rate. The value of \code{alpha} must be between 0 and 1. The default value is 0.05.
#' @param alternative An \strong{optional} character string specifying the alternate hypothesis, must be one of "two.sided" (default), "less" or "greater".
#' @param B An \strong{optional} positive integer specifying the size of bootstrap sample. The dafault value is 500.
#' @seealso \code{\link{farm.test}}
rmTestTwoBoot <- function(X, Y, h0, alpha = 0.05, alternative = "two.sided", B = 500L) {
    .Call('_FarmTest_rmTestTwoBoot', PACKAGE = 'FarmTest', X, Y, h0, alpha, alternative, B)
}

#' @title FarmTest with unknown factors
#' @description Internal function implemented in C++ for FarmTest with unknown factors. This case is incorporated into \code{farm.test}.
#' @param X An \eqn{n} by \eqn{p} data matrix with each row being a sample.
#' @param h0 A \eqn{p}-vector of true means.
#' @param K An \strong{optional} positive number of factors to be estimated for \code{X}. \code{K} cannot exceed the number of columns of \code{X}. If \code{K} is not specified or specified to be negative, it will be estimated internally.
#' @param alpha An \strong{optional} level for controlling the false discovery rate. The value of \code{alpha} must be between 0 and 1. The default value is 0.05.
#' @param alternative An \strong{optional} character string specifying the alternate hypothesis, must be one of "two.sided" (default), "less" or "greater".
#' @seealso \code{\link{farm.test}}
farmTest <- function(X, h0, K = -1L, alpha = 0.05, alternative = "two.sided") {
    .Call('_FarmTest_farmTest', PACKAGE = 'FarmTest', X, h0, K, alpha, alternative)
}

#' @title Two sample FarmTest with unknown factors
#' @description Internal function implemented in C++ for two sample FarmTest with unknown factors. This case is incorporated into \code{farm.test}.
#' @param X An \eqn{nX} by \eqn{p} data matrix with each row being a sample.
#' @param Y An \eqn{nY} by \eqn{p} data matrix with each row being a sample. The number of columns of \code{X} and \code{Y} must be the same.
#' @param h0 A \eqn{p}-vector of true difference in means.
#' @param KX An \strong{optional} positive number of factors to be estimated for \code{X}. \code{KX} cannot exceed the number of columns of \code{X}. If \code{KX} is not specified or specified to be negative, it will be estimated internally.
#' @param KY An \strong{optional} positive number of factors to be estimated for \code{Y}. \code{KY} cannot exceed the number of columns of \code{Y}. If \code{KY} is not specified or specified to be negative, it will be estimated internally.
#' @param alpha An \strong{optional} level for controlling the false discovery rate. The value of \code{alpha} must be between 0 and 1. The default value is 0.05.
#' @param alternative An \strong{optional} character string specifying the alternate hypothesis, must be one of "two.sided" (default), "less" or "greater".
#' @seealso \code{\link{farm.test}}
farmTestTwo <- function(X, Y, h0, KX = -1L, KY = -1L, alpha = 0.05, alternative = "two.sided") {
    .Call('_FarmTest_farmTestTwo', PACKAGE = 'FarmTest', X, Y, h0, KX, KY, alpha, alternative)
}

#' @title FarmTest with known factors
#' @description Internal function implemented in C++ for FarmTest with known factors. This case is incorporated into \code{farm.test}.
#' @param X An \eqn{n} by \eqn{p} data matrix with each row being a sample.
#' @param fac A factor matrix with each column being a factor for \code{X}. The number of rows of \code{fac} and \code{X} must be the same.
#' @param h0 A \eqn{p}-vector of true means.
#' @param alpha An \strong{optional} level for controlling the false discovery rate. The value of \code{alpha} must be between 0 and 1. The default value is 0.05.
#' @param alternative An \strong{optional} character string specifying the alternate hypothesis, must be one of "two.sided" (default), "less" or "greater".
#' @seealso \code{\link{farm.test}}
farmTestFac <- function(X, fac, h0, alpha = 0.05, alternative = "two.sided") {
    .Call('_FarmTest_farmTestFac', PACKAGE = 'FarmTest', X, fac, h0, alpha, alternative)
}

#' @title FarmTest with known factors and multiplier bootstrap
#' @description Internal function implemented in C++ for FarmTest with known factors, where p-values are obtained via multiplier bootstrap. 
#' This case is incorporated into \code{farm.test}.
#' @param X An \eqn{n} by \eqn{p} data matrix with each row being a sample.
#' @param fac A factor matrix with each column being a factor for \code{X}. The number of rows of \code{fac} and \code{X} must be the same.
#' @param h0 A \eqn{p}-vector of true means.
#' @param alpha An \strong{optional} level for controlling the false discovery rate. The value of \code{alpha} must be between 0 and 1. The default value is 0.05.
#' @param alternative An \strong{optional} character string specifying the alternate hypothesis, must be one of "two.sided" (default), "less" or "greater".
#' @param B An \strong{optional} positive integer specifying the size of bootstrap sample. The dafault value is 500.
#' @seealso \code{\link{farm.test}}
farmTestFacBoot <- function(X, fac, h0, alpha = 0.05, alternative = "two.sided", B = 500L) {
    .Call('_FarmTest_farmTestFacBoot', PACKAGE = 'FarmTest', X, fac, h0, alpha, alternative, B)
}

#' @title Two sample FarmTest with known factors
#' @description Internal function implemented in C++ for two sample FarmTest with known factors. This case is incorporated into \code{farm.test}.
#' @param X An \eqn{nX} by \eqn{p} data matrix with each row being a sample.
#' @param facX A factor matrix with each column being a factor for \code{X}. The number of rows of \code{facX} and \code{X} must be the same.
#' @param Y An \eqn{nY} by \eqn{p} data matrix with each row being a sample. The number of columns of \code{X} and \code{Y} must be the same.
#' @param facY A factor matrix with each column being a factor for \code{Y}. The number of rows of \code{facY} and \code{Y} must be the same.
#' @param h0 A \eqn{p}-vector of true difference in means.
#' @param alpha An \strong{optional} level for controlling the false discovery rate. The value of \code{alpha} must be between 0 and 1. The default value is 0.05.
#' @param alternative An \strong{optional} character string specifying the alternate hypothesis, must be one of "two.sided" (default), "less" or "greater".
#' @seealso \code{\link{farm.test}}
farmTestTwoFac <- function(X, facX, Y, facY, h0, alpha = 0.05, alternative = "two.sided") {
    .Call('_FarmTest_farmTestTwoFac', PACKAGE = 'FarmTest', X, facX, Y, facY, h0, alpha, alternative)
}

#' @title Two sample FarmTest with known factors and multiplier bootstrap
#' @description Internal function implemented in C++ for two sample FarmTest with known factors, where p-values are obtained via multiplier bootstrap. 
#' This case is incorporated into \code{farm.test}.
#' @param X An \eqn{nX} by \eqn{p} data matrix with each row being a sample.
#' @param facX A factor matrix with each column being a factor for \code{X}. The number of rows of \code{facX} and \code{X} must be the same.
#' @param Y An \eqn{nY} by \eqn{p} data matrix with each row being a sample. The number of columns of \code{X} and \code{Y} must be the same.
#' @param facY A factor matrix with each column being a factor for \code{Y}. The number of rows of \code{facY} and \code{Y} must be the same.
#' @param h0 A \eqn{p}-vector of true difference in means.
#' @param alpha An \strong{optional} level for controlling the false discovery rate. The value of \code{alpha} must be between 0 and 1. The default value is 0.05.
#' @param alternative An \strong{optional} character string specifying the alternate hypothesis, must be one of "two.sided" (default), "less" or "greater".
#' @param B An \strong{optional} positive integer specifying the size of bootstrap sample. The dafault value is 500.
#' @seealso \code{\link{farm.test}}
farmTestTwoFacBoot <- function(X, facX, Y, facY, h0, alpha = 0.05, alternative = "two.sided", B = 500L) {
    .Call('_FarmTest_farmTestTwoFacBoot', PACKAGE = 'FarmTest', X, facX, Y, facY, h0, alpha, alternative, B)
}

