% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{print.farm.test}
\alias{print.farm.test}
\title{Summarize and print the results of the multiple testing}
\usage{
\method{print}{farm.test}(x, ...)
}
\arguments{
\item{x}{A \code{farm.test} object.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
A list with the following items:
\item{means}{estimated means}
\item{stderr}{estimated standard errors}
\item{pvalue}{unadjusted p values}
\item{rejected}{the indices of rejected hypotheses, along with their corresponding p values, and adjusted p values, ordered from most significant to least significant}
\item{alldata}{all the indices of the tested hypotheses, along with their corresponding p values, adjusted p values, and a column with 1 if declared siginificant and 0 if not}
\item{loadings}{estimated factor loadings}
\item{nfactors}{number of (estimated) factors}
\item{n}{number of observations}
\item{p}{number of dimensions}
\item{alpha}{level at which FDR was controlled}
\item{H0}{null hypothesis}
\item{alternative}{alternate hypothesis}
\item{robust}{whether robust parameters were used}
\item{type}{whether the test is one or two-sided}
\item{significant}{the number of means that are found significant}
}
\description{
Print method for \code{farm.test} objects
}
\examples{
set.seed(100)
p = 50
n = 100
X = matrix(rnorm( p*n, 0,1), nrow = n)
output = farm.test(X)
output
names(output)
}
\seealso{
\code{\link{farm.test}}
}
