% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{farm.scree}
\alias{farm.scree}
\title{Diagnostic plots and quantities arising from estimating the number of underlying factors}
\usage{
farm.scree(X, K.scree = NULL, K.factors = NULL, robust = FALSE)
}
\arguments{
\item{X}{an n x p data matrix with each row being a sample.}

\item{K.scree}{an \emph{optional} integer specifying the number of eigenvalues to be plotted in the scree plot. Default is min(n,p).}

\item{K.factors}{an \emph{optional} integer specifying the number of eigenvalues to be used for the eigenvalue ratio test. Default is min(n,p)/2.}

\item{robust}{a TRUE/FALSE indicating whether to use a robust covariance estimator if TRUE, or the sample covariance estimator. Default is FALSE.}
}
\value{
Two plots: First plot is the scree plot of the data. Second plot illustrates the eigenvalue ratio test.

A list with the data used for the plots:
\itemize{
 \item{\code{eigenvalues} }{Eigenvalues of the covariance matrix}
 \item{\code{proportions} }{Proportion of variance explained by the principal components}
 \item{\code{eigenvalue.ratios} }{Ratios calculated in the eigenvalue ratio test}
 \item{\code{nfactors} }{Number of factors found using the eigenvalue ratio test}
}
}
\description{
Given the data, this function  draws a scree plot and a plot of the eigenvalue ratios.
The eignevalue ratio test is used to estimate the number of factors. See Ahn and Horenstein(2013).
}
\details{
The maximum eigenvalue ratio is marked differently on the plot.  The index of this maximum ratio gives the number of estimated factors.

User has to hit <Return> to see the second plot.

All the data used in the plots are output as a list.
}
\examples{
set.seed(100)
p = 100
n = 20
epsilon = matrix(rnorm( p*n, 0,1), nrow = n)
B = matrix(rnorm(p*3,0,1), nrow=p)
fx = matrix(rnorm(3*n, 0,1), nrow = n)
X = fx\%*\%t(B)+ epsilon
ouput = farm.scree(X)

}
\references{
Ahn, S. C. and Horenstein, A. R.  (2013). "Eigenvalue Ratio Test for the Number of Factors," Econometrica, 81 (3), 1203–1227.
}
