% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSAUtils.R
\name{validn}
\alias{validn}
\title{Finds the number of valid (non-NA) values in a vector.}
\usage{
validn(object)
}
\arguments{
\item{object}{A vector.}
}
\value{
A single numeric value that is the number of non-\code{NA} values in a vector.
}
\description{
Finds the number of valid (non-NA) values in a vector.
}
\section{IFAR Chapter}{
 2-Basic Data Manipulations.
}

\examples{
junk1 <- c(1,7,2,4,3,10,NA)
junk2 <- c("Derek","Hugh","Ogle","Santa","Claus","Nick",NA,NA)
junk3 <- factor(junk2)
junk4 <- c(TRUE,TRUE,FALSE,FALSE,FALSE,TRUE,NA,NA)
junk5 <- data.frame(junk1)
junk6 <- data.frame(junk3)

validn(junk1)
validn(junk2)
validn(junk3)
validn(junk4)
validn(junk5)
validn(junk6)
 
}
\seealso{
See \code{\link[plotrix]{valid.n}} in \pkg{plotrix} and \code{nobs} in \pkg{gdata} for similar functionality. See \code{\link{is.na}} for finding the missing values.
}
\author{
Derek H. Ogle, \email{DerekOgle51@gmail.com}
}
\keyword{manip}
