% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/geometryfns.R
\docType{methods}
\name{BAUs_from_points}
\alias{BAUs_from_points}
\alias{BAUs_from_points,SpatialPoints-method}
\alias{BAUs_from_points,ST-method}
\title{Creates pixels around points}
\usage{
BAUs_from_points(obj)

\S4method{BAUs_from_points}{SpatialPoints}(obj)

\S4method{BAUs_from_points}{ST}(obj)
}
\arguments{
\item{obj}{object of class \code{SpatialPointsDataFrame}}
}
\description{
Takes a SpatialPointsDataFrame and converts it into SpatialPolygonsDataFrame by constructing a tiny (within machine tolerance) BAU around each SpatialPoint.
}
\details{
This function is there to allow users to mimic standard geospatial analysis where BAUs are not used. Since \code{FRK} is build on the concept of a BAU, this function constructs tiny BAUs around the observation and prediction locations which can be subsequently passed on to the functions \code{SRE} and \code{FRK}. With \code{BAUs_from_points}, the user supplies both the data and prediction locations accompanied with covariates.
}
\examples{
library(sp)
opts_FRK$set("parallel",0L)
df <- data.frame(x = rnorm(10),
                 y = rnorm(10))
coordinates(df) <- ~x+y
BAUs <- BAUs_from_points(df)
}
