% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FMAT.R
\name{FMAT_run}
\alias{FMAT_run}
\title{Run the fill-mask pipeline on multiple models.}
\usage{
FMAT_run(
  models,
  data,
  file = NULL,
  progress = c(FALSE, TRUE, "none", "text", "time"),
  parallel = FALSE,
  ncores = 4,
  warning = TRUE
)
}
\arguments{
\item{models}{Language model(s):
\itemize{
  \item{Model names (usually the BERT-based models) at
   \href{https://huggingface.co/models}{HuggingFace}.}
  \item{A list of mask filling pipelines loaded by \code{\link{FMAT_load}}.

   * You will need to \strong{rerun} \code{\link{FMAT_load}}
   if you \strong{restart} the R session.}
}}

\item{data}{A data.table returned from
\code{\link{FMAT_query}} or \code{\link{FMAT_query_bind}}.}

\item{file}{File name of \code{.RData} to save the returned data.}

\item{progress}{Show a progress bar:
\code{"none"} (\code{FALSE}), \code{"text"} (\code{TRUE}), \code{"time"}.}

\item{parallel}{Parallel processing (NOT suggested).
Defaults to \code{FALSE}.
If \code{TRUE}, then \code{models} must be model names
rather than from \code{\link{FMAT_load}}.

* For small-scale \code{data},
parallel processing would instead be \emph{slower}
because it takes time to create a parallel cluster.}

\item{ncores}{Number of CPU cores to be used in parallel processing.}

\item{warning}{Warning of out-of-vocabulary word(s). Defaults to \code{TRUE}.}
}
\value{
A data.table (of new class \code{fmat}) appending \code{data}
with these new variables:
\itemize{
  \item{\code{model}: model name.}
  \item{\code{output}: complete sentence output with unmasked token.}
  \item{\code{token}: actual token to be filled in the blank mask
  (a note "out-of-vocabulary" will be added
  if the original word is not found in the model vocabulary).}
  \item{\code{prob}: (raw) conditional probability of the unmasked token
  given the provided context, estimated by the masked language model.

  * It is NOT SUGGESTED to directly interpret the raw probabilities
  because the \emph{contrast} between a pair of probabilities
  is more interpretable. See \code{\link{summary.fmat}}.}
}
}
\description{
Run the fill-mask pipeline on multiple models.
}
\details{
The function will also automatically adjust for
the compatibility of tokens used in certain models:
(1) for uncased models (e.g., ALBERT), it turns tokens to lowercase;
(2) for models that use \code{<mask>} rather than \code{[MASK]},
it automatically uses the corrected mask token;
(3) for models that require a prefix to estimate whole words than subwords
(e.g., ALBERT, RoBERTa), it adds a certain prefix (usually a white space;
\\u2581 for ALBERT and XLM-RoBERTa, \\u0120 for RoBERTa and DistilRoBERTa).

Note that these changes only affect the \code{token} variable
in the returned data, but will not affect the \code{M_word} variable.z
Thus, users may analyze their data based on the unchanged \code{M_word}
rather than the \code{token}.
}
\examples{
# Running the example requires the models downloaded
# You will need to rerun `FMAT_load` if you restart the R session

\donttest{models = FMAT_load(c("bert-base-uncased", "bert-base-cased"))

query1 = FMAT_query(
  c("[MASK] is {TARGET}.", "[MASK] works as {TARGET}."),
  MASK = .(Male="He", Female="She"),
  TARGET = .(Occupation=cc("a doctor, a nurse, an artist"))
)
data1 = FMAT_run(models, query1)
summary(data1, target.pair=FALSE)

query2 = FMAT_query(
  "The [MASK] {ATTRIB}.",
  MASK = .(Male=cc("man, boy"),
           Female=cc("woman, girl")),
  ATTRIB = .(Masc=cc("is masculine, has a masculine personality"),
             Femi=cc("is feminine, has a feminine personality"))
)
data2 = FMAT_run(models, query2)
summary(data2, mask.pair=FALSE)
summary(data2)

query3 = FMAT_query(
  "The association between {TARGET} and {ATTRIB} is [MASK].",
  MASK = .(H="strong", L="weak"),
  TARGET = .(Flower=cc("rose, iris, lily"),
             Insect=cc("ant, cockroach, spider")),
  ATTRIB = .(Pos=cc("health, happiness, love, peace"),
             Neg=cc("death, sickness, hatred, disaster"))
)
data3 = FMAT_run(models, query3)
summary(data3, attrib.pair=FALSE)
summary(data3)
}
}
\seealso{
\code{\link{FMAT_load}}

\code{\link{FMAT_query}}

\code{\link{FMAT_query_bind}}

\code{\link{summary.fmat}}
}
