% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popFilters.R
\name{popFilters}
\alias{popFilters}
\title{Population data filters.}
\usage{
popFilters(
  evalid = NULL,
  invyrs = NULL,
  intensity = NULL,
  ACI = FALSE,
  AOIonly = FALSE,
  ...
)
}
\arguments{
\item{evalid}{Numeric. FIA Evaluation identifier for subsetting plots for
population.}

\item{invyrs}{Integer vector. Inventory year(s) (e.g., c(2000, 2001, 2002)).}

\item{intensity}{Integer code. Code(s) indicating intensity to use for
population.}

\item{ACI}{Logical. If TRUE, including All Condition Inventory (ACI) plots.}

\item{AOIonly}{Logical. If TRUE, and there is an AOI (1/0) attribute in the
population data, only AOI=1 are used for estimation.}

\item{...}{For extendibility.}
}
\value{
A list of user-supplied parameters and parameter values for population
data filters.
}
\description{
Returns a list of user-supplied parameters and parameter values for population
data filters.
}
\details{
If no parameters, an empty list is returned.
}
\examples{
popFilters(ACI = TRUE)
}
\author{
Grayson W. White
}
\keyword{filters}
