% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{getFE}
\alias{getFE}
\title{Extract the Fixed-Effects from a \code{femlm} estimation.}
\usage{
getFE(x)
}
\arguments{
\item{x}{A femlm object.}
}
\value{
A list containig the vectors of the fixed effects.
}
\description{
This function retrives the fixed effects from a femlm estimation. It is useful only when there are more than one cluster.
}
\examples{

# Bilateral network
nb = 20
n = nb**2
k = nb
id1 = factor(rep(1:k, each=n/k))
id2 = factor(rep(1:(n/k), times=k))
d = rep(rnorm(k)**2, each=n/k)
x = rnorm(n, 1, 5)**2
y = rnorm(n, -1, 5)**2
z = rpois(n, x*y+rnorm(n, sd = 3)**2) + rpois(n, 2)
base = data.frame(x, y, z, id1, id2)

# We want to use the ID's of each observation as a variable: we use the option cluster
est_poisson = femlm(z~log(x)+log(y), base, family="poisson", cluster=c("id1", "id2"))

# To get the FE:
myFE = getFE(est_poisson)

}
\seealso{
See also the main estimation function \code{\link[FENmlm]{femlm}}. Use \code{\link[FENmlm]{summary.femlm}} to see the results with the appropriate standard-errors, \code{\link[FENmlm]{getFE}} to extract the cluster coefficients, and the functions \code{\link[FENmlm]{res2table}} and \code{\link[FENmlm]{res2tex}} to visualize the results of multiple estimations.
}
\author{
Laurent Berge
}
