% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/FDboost.R
\name{FDboost}
\alias{FDboost}
\title{Model-based Gradient Boosting for Functional Response}
\usage{
FDboost(formula, timeformula, id = NULL, numInt = "equal", data,
  weights = NULL, offset = NULL, offset_control = o_control(),
  check0 = FALSE, ...)
}
\arguments{
\item{formula}{a symbolic description of the model to be fit.}

\item{timeformula}{formula for the expansion over the index of the response.
For a functional response \eqn{Y_i(t)} typically \code{~bbs(t)} to obtain a smooth
expansion of the effects along \code{t}. In the limiting case that \eqn{Y_i} is a scalar response
use \code{~bols(1)}, which sets up a base-learner for the scalar 1.}

\item{id}{defaults to NULL which means that the response is a matrix with a regular time.
If the response is given in long format for irregular observations, \code{id}
contains the information which observations belong together.
\code{id} should contain numbers 1, 2, 3, ...}

\item{numInt}{integration scheme for the integration of the loss function.
One of \code{c("equal", "Riemann")} meaning equal weights of 1 or
trapezoidal Riemann weights.
Alternatively a vector of length \code{nrow(response)} containing arbitrary
positive weights can be specified.}

\item{data}{a data frame or list containing the variables in the model.}

\item{weights}{(1) a numeric vector of weights for observational units,
i.e. \code{length(weights)} has to be \code{nrow(response)},
(2) alternatively weights can be specified for single observations then
\code{length(weights)} has to be \code{nrow(response)}*\code{ncol(response)}
per default weights is constantly 1.}

\item{offset}{a numeric vector to be used as offset over the index of the response (optional).
If no offset is specified, per default a smooth time-specific offset is calculated and used
within the model fit. If you do not want to use an offset you can set \code{offset=0}.}

\item{offset_control}{parameters for the calculation of the offset,
defaults to \code{o_control(k_min=20, silent=TRUE)}, see \code{\link{o_control}}.}

\item{check0}{logical, for response observed on a common grid,
check the fitted effects for the sum-to-zero constraint
\eqn{h_j(x_i)(t) = 0} for all \eqn{t} and give warning if it is not fulfilled. Defaults to TRUE.}

\item{...}{additional arguments passed to \code{\link[mboost]{mboost}},
including, \code{family} and \code{control}.}
}
\value{
on object of class \code{FDboost} that inherits from \code{mboost}.
Special \code{\link{predict.FDboost}}, \code{\link{coef.FDboost}} and
\code{\link{plot.FDboost}} methods are available.
The methods of \code{\link[mboost]{mboost}} are available as well,
e.g. \code{\link[mboost]{extract}}.

The \code{FDboost}-object is a named list containing:
\item{...}{all elements of an \code{\link[mboost]{mboost}-object}}
\item{yname}{the name of the response}
\item{yind}{the observation points of the response, with its name as attribute}
\item{data}{the data that was used for the model fit}
\item{id}{NULL for a response over a regular grid, otherwise the id variable of the response}
\item{predictOffset}{the function to predict the smooth offset}
\item{offsetVec}{the offset for one trajectory for regular response and
otherwise the offset for all trajectories}
\item{callEval}{the evaluated function call}
\item{timeformula}{the time-formula}
\item{formulaFDboost}{the formula with which \code{FDboost} was called}
\item{formulaMboost}{the formula with which \code{mboost} was called within \code{FDboost}}
}
\description{
Gradient boosting for optimizing arbitrary loss functions, where component-wise models
are utilized as base-learners in the case of functional response.
Scalar responses are treated as the special case where each functional response has
only one observation.
This function is a wrapper for \code{mboost}'s \code{\link[mboost]{mboost}} and its
siblings to fit models of the general form
\cr \eqn{xi(Y_i(t)) = \sum_j h_j(x_i, t)} \cr
with a functional (but not necessarily continuous) response \eqn{Y(t)},
transformation function \eqn{xi}, e.g. the expectation, the median or some quantile,
and partial effects \eqn{h_j(x_i, t)} depending on covariates
and the current index of the response.
Possible effects are e.g. a smooth intercept \eqn{\mu(t)},
effects of functional covariates \eqn{\int X_i(s)\beta(s,t)ds},
smooth and linear effects of scalar covariates \eqn{f(z_{i})}, \eqn{z_{i} \beta_3(t)}.
}
\details{
The functional response and functional covariates have to be
supplied as n by <no. of evaluations> matrices, i.e. each row is one
functional observation. For the model fit the matrix of the functional
response evaluations \eqn{Y_i(t)} are stacked into one long vector.
If it is possible to write the model as a generalized linear array model,
the array structure is used as efficient implementation,
see \code{\link[mboost]{mboost}}.
If the response is observed irregularly or sparse it can be supplied
as a vector in long format. In that case the argument \code{id} has
to be specified as integers 1, 2, 3, ... to define which observation
belongs to which curve.
}
\examples{
## Example for function-on-scalar-regression
data("viscosity", package = "FDboost")
## set time-interval that should be modeled
interval <- "101"

## model time until "interval" and take log() of viscosity
end <- which(viscosity$timeAll==as.numeric(interval))
viscosity$vis <- log(viscosity$visAll[,1:end])
viscosity$time <- viscosity$timeAll[1:end]
# with(viscosity, funplot(time, vis, pch=16, cex=0.2))

## fit median regression model with 100 boosting iterations,
## step-length 0.4 and smooth time-specific offset
## the factors are in effect coding -1, 1 for the levels
mod1 <- FDboost(vis ~ 1 + bols(T_C, contrasts.arg = "contr.sum", intercept=FALSE)
               + bols(T_A, contrasts.arg = "contr.sum", intercept=FALSE),
               timeformula=~bbs(time, lambda=100),
               numInt="Riemann", family=QuantReg(),
               offset=NULL, offset_control = o_control(k_min = 9),
               data=viscosity, control=boost_control(mstop = 100, nu = 0.4))
summary(mod1)
## plot(mod1)

## Example for scalar-on-function-regression
data("fuelSubset", package = "FDboost")

mod2 <- FDboost(heatan ~ bsignal(UVVIS, uvvis.lambda, knots=40, df=4, check.ident=FALSE)
               + bsignal(NIR, nir.lambda, knots=40, df=4, check.ident=FALSE),
               timeformula=~bols(1), data=fuelSubset)
summary(mod2)
## plot(mod2)

## Example for function-on-function-regression
if(require(fda)){
  data("CanadianWeather", package="fda")
  CanadianWeather$l10precip <- t(log(CanadianWeather$monthlyPrecip))
  CanadianWeather$temp <- t(CanadianWeather$monthlyTemp)
  CanadianWeather$region <- factor(CanadianWeather$region)
  CanadianWeather$month.s <- CanadianWeather$month.t <- 1:12

  ## fit model with cyclic splines over the year
  mod3 <- FDboost(l10precip ~ bols(region, df=2.5, contrasts.arg = "contr.dummy")
                 + bsignal(temp, month.s, knots=11, cyclic=TRUE,
                           df=2.5, boundary.knots=c(0.5,12.5), check.ident=FALSE),
                 timeformula=~bbs(month.t, knots=11, cyclic=TRUE,
                                  df=3, boundary.knots=c(0.5,12.5)),
                                  offset=0, offset_control = o_control(k_min=5),
                  data=CanadianWeather)
 summary(mod3)
 ## plot(mod3, pers=TRUE)
}
}
\author{
Sarah Brockhaus, Torsten Hothorn
}
\references{
Brockhaus, S., Scheipl, F., Hothorn, T. and Greven, S. (2015).
The Functional Linear Array Model. Statistical Modelling, in press.
}
\seealso{
\code{\link[mboost]{mboost}} for the help of the wrapped function in
package mboost.
See \code{\link[FDboost]{bsignal}} and \code{\link[FDboost]{bbsc}}
for possible base-learners
}
\keyword{models,}
\keyword{nonlinear}

