% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FCVAR_estn.R
\name{FCVARestn}
\alias{FCVARestn}
\title{Estimate FCVAR model}
\usage{
FCVARestn(x, k, r, opt)
}
\arguments{
\item{x}{A matrix of variables to be included in the system.}

\item{k}{The number of lags in the system.}

\item{r}{The cointegrating rank.}

\item{opt}{An S3 object of class \code{FCVAR_opt} that stores the chosen estimation options,
generated from \code{FCVARoptions()}.}
}
\value{
An S3 object of class \code{FCVAR_model} containing the estimation results,
including the following parameters:
\describe{
  \item{\code{startVals}}{Starting values used for optimization.}
  \item{\code{options}}{Estimation options.}
  \item{\code{like}}{Model log-likelihood.}
  \item{\code{coeffs}}{Parameter estimates.}
  \item{\code{rankJ}}{Rank of Jacobian for the identification condition.}
  \item{\code{fp}}{Number of free parameters.}
  \item{\code{SE}}{Standard errors.}
  \item{\code{NegInvHessian}}{Negative of inverse Hessian matrix.}
  \item{\code{Residuals}}{Model residuals.}
  \item{\code{cPolyRoots}}{Roots of characteristic polynomial.}
  \item{\code{printVars}}{Additional variables required only for printing
  the output of \code{FCVARestn} to screen.}
  \item{\code{k}}{The number of lags in the system.}
  \item{\code{r}}{The cointegrating rank.}
  \item{\code{p}}{The number of variables in the system.}
  \item{\code{cap_T}}{The sample size.}
  \item{\code{opt}}{An S3 object of class \code{FCVAR_opt} that stores the chosen estimation options,
    generated from \code{FCVARoptions()}.}
}
}
\description{
\code{FCVARestn} estimates the Fractionally Cointegrated VAR model.
 It is the central function in the \code{FCVAR} package with several nested functions, each
	described below. It estimates the model parameters, calculates the
	standard errors and the number of free parameters, obtains the residuals
	and the roots of the characteristic polynomial.
\code{print.FCVARestn} prints the estimation results from
the output of \code{FCVARestn}.
}
\examples{
\donttest{
opt <- FCVARoptions()
opt$gridSearch   <- 0 # Disable grid search in optimization.
opt$dbMin        <- c(0.01, 0.01) # Set lower bound for d,b.
opt$dbMax        <- c(2.00, 2.00) # Set upper bound for d,b.
opt$constrained  <- 0 # Impose restriction dbMax >= d >= b >= dbMin ? 1 <- yes, 0 <- no.
x <- votingJNP2014[, c("lib", "ir_can", "un_can")]
m1 <- FCVARestn(x, k = 2, r = 1, opt)
}

\donttest{
opt1 <- opt
opt1$R_psi <- matrix(c(1, 0), nrow = 1, ncol = 2)
opt1$r_psi <- 1
m1r1 <- FCVARestn(x, k = 2, r = 1, opt1)
}

\donttest{
opt1 <- opt
opt1$R_Beta <- matrix(c(1, 0, 0), nrow = 1, ncol = 3)
m1r2 <- FCVARestn(x, k = 2, r = 1, opt1)
}

\donttest{
opt1 <- opt
opt1$R_Alpha <- matrix(c(0, 1, 0), nrow = 1, ncol = 3)
m1r4 <- FCVARestn(x, k = 2, r = 1, opt1)
}
}
\seealso{
\code{FCVARoptions} to set default estimation options.
\code{FCVARestn} calls this function at the start of each estimation to verify
validity of options.
\code{summary.FCVAR_model} prints the output of \code{FCVARestn} to screen.

Other FCVAR estimation functions: 
\code{\link{FCVARoptions}()},
\code{\link{summary.FCVAR_model}()}
}
\concept{FCVAR estimation functions}
