% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binTimeSeries.R
\name{binTimeSeries}
\alias{binTimeSeries}
\title{Binned representation of a time series}
\usage{
binTimeSeries(f, acqTime, nIntervals, mode = "mean", plot = TRUE)
}
\arguments{
\item{f}{Numeric vector}

\item{acqTime}{Point acquisition rate (in seconds)}

\item{nIntervals}{Number of intervals into which the vector will be grouped}

\item{mode}{Set to "mean" (default) or "sum" to average or sum all the points in every interval, respectively}

\item{plot}{Boolean, set to TRUE (default) to plot the result}
}
\value{
A data frame with two variables (Counts and Time) and 'nIntervals' observations
}
\description{
Groups large vectors into several bins of a given length for better (and faster) data plotting
}
\details{
This function groups all the points in the vector 'f' into 'nIntervals' bins of length = length(f)/nIntervals.
Then, averages or sums all of the points in each bin and plots the result.
}
\examples{
\donttest{
### Please navigate to
### (https://github.com/FCSlib/FCSlib/tree/master/Sample\%20Data)
### to find this sample data

# Automatic plot
x <- readFileTiff("Cy5.tif")
x <- as.vector(x)
x <- binTimeSeries(x[length(x):1], 2e-6, 100, mode = "mean", plot = T)

# Manual plot (useful for adding custom labels)
x <- readFileTiff("Cy5.tif")
x <- as.vector(x)
x <- binTimeSeries(x[length(x):1], 2e-6, 100, mode = "mean", plot = F)
plot(x$Counts~x$Time, type = "l")
}
}
\seealso{
\code{\link{binMatrix}}
}
\author{
Alejandro Linares
}
