% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metabolicanalysis.R
\name{desaturationAnalysis}
\alias{desaturationAnalysis}
\title{Desaturation analysis of fatty acids.}
\usage{
desaturationAnalysis(
  fadata,
  desaturationsdb = FAMetA::desaturationsdb,
  SEThr = 0.05
)
}
\arguments{
\item{fadata}{fadata containing synthesis and elongation results.}

\item{desaturationsdb}{desaturation reactions considered. It can be
modified to change them or to add new reactions.}

\item{SEThr}{minimum S or E value allowed to perform estimate desaturations.}
}
\value{
fadata list. Desaturation analysis results will be saved at the 
desaturation element of the fa list.
}
\description{
Desaturation analysis of fatty acids.
}
\details{
Once synthesis and elongation parameters have been estimated, these
results can be used to calculate the FA fraction that comes from desaturation
in unsaturated FA. For a given unsaturated FA (e.g. FA(18:1n9) we can
conceptually consider a one-step elongation-desaturation reaction (in this
example directly from FA(16:0) to FA(18:1n9) (E1') or a two-step elongation
followed by desaturation process (in this example FA(16:0) is elongated to
FA(18:0) (E1) and then desaturated to FA(18:1n9) (Des). Therefore,
desaturation can be estimated based on the fraction of E1', which is E1 from
FA(18:1)n9, and E1, which is E1 from FA(18:0). This same model can be used
for all known desaturation steps (see FAMetA::desaturationsdb) as long as
precursor and product FA isomers have been correctly and uniquely identified
and stationary state has been reached.
}
\examples{
\donttest{
ssdata <- dataCorrection(ssexamplefadata, blankgroup = "Blank")
ssdata <- synthesisAnalysis(ssdata, R2Thr = 0.95, 
maxiter = 1e3, maxconvergence = 100, startpoints = 5)
ssdata <- elongationAnalysis(ssdata, R2Thr = 0.95, maxiter = 1e3,
maxconvergence=100, startpoints = 5, D2Thr = 0.1)
ssdata <- desaturationAnalysis(ssdata, SEThr = 0.05)
}

\dontrun{
fadata <- dataCorrection(examplefadata, blankgroup = "Blank")
fadata <- synthesisAnalysis(fadata, R2Thr = 0.95, maxiter = 1e3,
maxconvergence = 100, startpoints = 5)
fadata <- elongationAnalysis(fadata, R2Thr = 0.95, maxiter = 1e4,
maxconvergence = 100, startpoints = 5, D2Thr = 0.1)
fadata <- desaturationAnalysis(fadata, SEThr = 0.05)
}

}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
