% Generated by roxygen2 (4.0.2): do not edit by hand
\name{Weibull}
\alias{Weibull}
\alias{dWeibull}
\alias{eWeibull}
\alias{lWeibull}
\alias{pWeibull}
\alias{qWeibull}
\alias{rWeibull}
\title{The Weibull Distribution.}
\usage{
dWeibull(x, shape = 2, scale = 2, params = list(shape = 2, scale = 2))

pWeibull(q, shape = 2, scale = 2, params = list(shape = 2, scale = 2))

qWeibull(p, shape = 2, scale = 2, params = list(shape = 2, scale = 2))

rWeibull(n, shape = 2, scale = 2, params = list(shape = 2, scale = 2))

eWeibull(X, w, method = "numerical.MLE")

lWeibull(X, w, shape = 2, scale = 2, params = list(shape = 2, scale = 2),
  logL = TRUE)
}
\arguments{
\item{x,q}{vector of quantiles.}

\item{shape}{shape parameter.}

\item{scale}{scale parameter.}

\item{params}{a list includes all parameters}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}

\item{X}{sample observations.}

\item{w}{weights of sample.}

\item{method}{parameter estimation method.}

\item{logL}{logical; if TRUE, lWeibull gives log likelihood.}

\item{...}{other parameters}
}
\value{
dWeibull gives the density; pWeibull gives the distribution function;
qWeibull gives the quantile function; rWeibull generates random variables;
eWeibull estimate the parameters
}
\description{
Density, distribution function, quantile function, random
generation function and parameter estimation function (based on weighted or
unweighted i.i.d. sample) for the Weibull distribution
}
\details{
Weibull Distribution

See \href{../doc/Distributions-Weibull.html}{Distributions-Weibull}
}
\examples{
\donttest{
# Parameter estimation
n <- 500
shape <- 1.5
scale <- 0.5
X <- rWeibull(n, shape, scale)
(est.par <- eWeibull(X))

# Histogram and fitted density
den.x <- seq(min(X),max(X),length=100)
den.y <- dWeibull(den.x,shape=est.par$shape,scale=est.par$scale)
hist(X, breaks=10, col="red", probability=TRUE, ylim = c(0,1.1*max(den.y)))
lines(den.x, den.y, col="blue", lwd=2)

# Q-Q plot and P-P plot
plot(qWeibull((1:n-0.5)/n, params=est.par), sort(X), main="Q-Q Plot",
xlab="Theoretical Quantiles", ylab="Sample Quantiles", xlim = c(0,5), ylim = c(0,5))
abline(0,1)

plot((1:n-0.5)/n, pWeibull(sort(X), params=est.par), main="P-P Plot",
xlab="Theoretical Percentile", ylab="Sample Percentile", xlim = c(0,1), ylim = c(0,1))
abline(0,1)

# A weighted parameter estimation example
n <- 10
par <- list(shape=1, scale=2)
X <- rWeibull(n, params=par)
w <- c(0.13, 0.06, 0.16, 0.07, 0.2, 0.01, 0.06, 0.09, 0.1, 0.12)
eWeibull(X,w) # estimated parameters of weighted sample
eWeibull(X) # estimated parameters of unweighted sample

# Extracting shape or scale parameters
est.par[attributes(est.par)$par.type=="shape"]
est.par[attributes(est.par)$par.type=="scale"]

# evaluate the performance of the parameter estimation function by simulation
eval.estimation(rdist=rWeibull,edist=eWeibull,n = 1000, rep.num = 1e3,
   params = list(shape=1, scale=2))

# evaluate the precision of estimation by Hessian matrix
X <- rWeibull(1000, shape, scale)
(est.par <- eWeibull(X))
H <- attributes(eWeibull(X, method = "numerical.MLE"))$nll.hessian
fisher_info <- solve(H)
sqrt(diag(fisher_info))

# log-likelihood, score vector and observed information matrix
lWeibull(X,param = est.par)
lWeibull(X,param = est.par, logL=FALSE)
}
}
\author{
Haizhen Wu and A. Jonathan R. Godfrey
}

