% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pick_resolution.R
\name{pick_resolution}
\alias{pick_resolution}
\title{Get the dpi resolution on an image (Obter a resolução em dpi em uma imagem).}
\usage{
pick_resolution(im,inches=NULL,centimeters=NULL,several=TRUE,col="red")
}
\arguments{
\item{im}{:Image in ExpImage format (Imagem no formato do ExpImage).}

\item{inches}{:reference object size in inches (tamanho do objeto de referencia em polegadas).}

\item{centimeters}{:reference object size in centimeters (tamanho do objeto de referencia em centimetros).}

\item{several}{:TRUE: If you want to get the DPI from the average of several measurements (TRUE: Se deseja obter o DPI a partir da média de várias medidas ).}

\item{col}{: Font color (Cor da fonte).}
}
\value{
Returns the resolution in DPI of an image. (Retorna a resolução em uma imagem).
}
\description{
Obter o numero de pixels por centimetros ou polegadas em uma imagem
(Get the number of pixels per centimeters or inches in an image).
}
\examples{
\dontrun{
im=read_image(example_image(3),plot=TRUE)
dpi=pick_resolution(im,centimeters=8.5)
dpi$dpi
pick_length(im,dpi = dpi$dpi)

}

}
\seealso{
\code{\link{pick_color}} , \code{\link{pick_length}}
}
\author{
Alcinei Mistico Azevedo (Instituto de ciencias agrarias da UFMG)
}
