% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oneillmathews.r
\name{oneillmathews}
\alias{oneillmathews}
\title{Teste de homogeneidade de variancias de ONeill e Mathews.}
\usage{
oneillmathews(trat, resp, t, r)
}
\arguments{
\item{trat}{Vetor numerico ou complexo contendo os
tratamentos.}

\item{resp}{Vetor numerico ou complexo contendo a variavel
resposta.}

\item{t}{Escalar. Numero de tratamentos.}

\item{r}{Vetor numerico ou complexo contendo o numero de
repeticoes de cada tratamento.}
}
\value{
Retorna o valor-p do teste de homogeneidade de
variancias de ONeill e Mathews para uma hipotese nula de que
as variancias sao homogenenas.
}
\description{
\code{oneillmathews} Executa o teste de homogeneidade de
variancias de ONeill e Mathews (2000) para um delineamento
inteiramente casualizado.
}
\examples{
data(ex1)
attach(ex1)
dic(trat, ig, quali = FALSE, hvar = "oneillmathews",
sigF = 0.05)
}
\references{
O'NEILL, M. E.; MATHEWS, K. L. A weighted least
squares approach to levene test of homogeneity of variance.
\emph{Australian e New Zealand Journal Statistical},
42(1):81-100, 2000.

NOGUEIRA, D, P.; PEREIRA, G, M. Desempenho de testes para
homogeneidade de variancias em delineamentos inteiramente
casualizados. \emph{Sigmae}, Alfenas, v.2, n.1, p. 7-22.
2013.
}
\seealso{
\code{\link{bartlett}}, \code{\link{layard}},
\code{\link{levene}}, \code{\link{samiuddin}}.
}
\author{
Eric B Ferreira,
 \email{eric.ferreira@unifal-mg.edu.br}
 @author Denismar Alves Nogueira
 @author Marcos Costa de Paula
 @author Mateus Pimenta Siqueira Lima
}
