% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepapre_regression_table.R
\name{prepare_regression_table}
\alias{prepare_regression_table}
\title{Prepares a Regression Table}
\usage{
prepare_regression_table(df, dvs, idvs, feffects = rep("", length(dvs)),
  clusters = rep("", length(dvs)), byvar = "", format = "html",
  drop_underscore = NULL)
}
\arguments{
\item{df}{Data frame containing the data to estimate the models on.}

\item{dvs}{A character vector containing the dependent variable(s).}

\item{idvs}{A character vector or a a list of character vectors containing the independent variables.}

\item{feffects}{A character vector or a a list of character vectors containing the fixed effects.}

\item{clusters}{A character vector or a a list of character vectors containing the cluster variables.}

\item{byvar}{A factorial variable to estimate the model on (only possible if only one model is being estimated).}

\item{format}{A character scalar that is passed on \code{\link[stargazer]{stargazer}} as \code{type} to determine the presentation
format ("html", "text", or "latex").}

\item{drop_underscore}{A quick'n'dirty hack to address a bug in stargazer that triggers it to choke on underscores in variable names.
If not NULL, all underscores in variable names will be replaced by the given string.}
}
\value{
A list containing two items
\describe{
 \item{"models"}{A list containing the model results and by values if appropriate}
 \item{"table"}{The output of \code{\link[stargazer]{stargazer}} containing the table}
}
}
\description{
Builds a regression table based on a set of user-specified models or a single model and a partitioning variable.
}
\details{
This is a wrapper function calling the stargazer package. Depending on whether the dependent variable
  is numeric or a factor with two levels, the models are estimated
  using \code{\link[lfe]{felm}} or \code{\link[stats]{glm}} (with \code{family = binomial(link="logit")}).
  Fixed effects and clustered standard errors are only supported with continuous dependent variables.
  If run with \code{byvar}, only levels that have more observations than coefficients are estimated.
}
\examples{
df <- data.frame(year = as.factor(floor(stats::time(datasets::EuStockMarkets))),
                 datasets::EuStockMarkets)
dvs = c("DAX", "SMI", "CAC", "FTSE")
idvs = list(c("SMI", "CAC", "FTSE"),
            c("DAX", "CAC", "FTSE"),
            c("SMI", "DAX", "FTSE"),
            c("SMI", "CAC", "DAX"))
feffects = list("year", "year", "year", "year")
clusters = list("year", "year", "year", "year")
t <- prepare_regression_table(df, dvs, idvs, feffects, clusters, format = "text")
t$table
t <- prepare_regression_table(df, "DAX", c("SMI", "CAC", "FTSE"), byvar="year", format = "text")
print(t$table)
}
