% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ESset.R
\name{ESset}
\alias{ESset}
\title{Evolutionarily stable set for two-player games with three strategies}
\usage{
ESset(A, strategies = c("1", "2", "3"), floats = TRUE)
}
\arguments{
\item{A}{Numeric matrix of size 3x3 representing the number of strategies of
a symmetric matrix game.}

\item{strategies}{String vector of length 3 that names all strategies.}

\item{floats}{Logical value that handles number representation. If set to
\code{TRUE}, floating-point arithmetic will be used, otherwise fractions.
Default is \code{TRUE}.}
}
\value{
Numeric matrix. Each row represents the start and end point of a
 line (ESset). In addition, a plot of the ESset in the game will be created.
}
\description{
Computes evolutionarily stable sets of a game with two players 
and three strategies.
}
\examples{
# Please note that the computation of evolutionarily stable sets 
# is rather time-consuming. 
# Depending on your machine you might need to wait more 
# than 10 seconds in order to run the following example.
\dontrun{
A <- matrix(c(-2, 5, 10/9, 0, 5/2, 10/9, -10/9, 35/9, 10/9), 3, byrow=TRUE)
strategies <- c("Hawk", "Dove", "Mixed ESS")
ESset(A, strategies)
}
}
\references{
Thomas, B. (1985)
"On evolutionarily stable sets", 
Journal of Mathematical Biology 22, pp. 105--115.
}
\author{
Daniel Gebele \email{dngebele@gmail.com}
}
