% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_object.R
\name{create_object}
\alias{create_object}
\title{Create an `EViews` object on a workfile from R}
\usage{
create_object(wf="",page="",action="",action_opt="",object_name="",
view_or_proc="",options_list="",arg_list="")
}
\arguments{
\item{wf}{Object or a character string representing the name of an `EViews` workfile.}

\item{page}{Object or a character string representing the name of an `EViews` workfile page.}

\item{action}{Any valid `EViews` command for `EViews` object declaration, like \code{freeze}, \code{do}, \code{equation}, \code{table}.}

\item{action_opt}{An option that modifies the default behaviour of the `EViews` action.}

\item{object_name}{The name of the `EViews` object to be acted upon.}

\item{view_or_proc}{The `EViews` object view or procedure to be performed.}

\item{options_list}{An option that modifies the default behaviour of the `EViews` view or procedure.}

\item{arg_list}{A list of `EViews` view or procedure arguments.}
}
\value{
An EViews workfile
}
\description{
Use this function to create an `EViews` object on a workfile from R
}
\examples{
library(EviewsR)
\dontrun{
demo(exec_commands)

create_object(wf="EviewsR_exec_commands",action="equation",action_opt="",
object_name="EviewsR_create_object",view_or_proc="ls",options_list="",arg_list="y ar(1)")
}
}
\seealso{
Other important functions: 
\code{\link{EviewsR}},
\code{\link{eng_eviews}()},
\code{\link{eviews_graph}()},
\code{\link{eviews_import}()},
\code{\link{eviews_pagesave}()},
\code{\link{eviews_wfcreate}()},
\code{\link{eviews_wfsave}()},
\code{\link{exec_commands}()},
\code{\link{export}()},
\code{\link{import_table}()},
\code{\link{import}()},
\code{\link{rwalk}()},
\code{\link{set_eviews_path}()}
}
\concept{important functions}
\keyword{documentation}
