% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eviews_import.R
\name{eviews_import}
\alias{eviews_import}
\title{Import data to `EViews` workfile}
\usage{
eviews_import(source_description="",wf="",type="",options="",smpl_string="",
genr_string="",rename_string="",frequency="",start_date="",id="",destid="",
append=FALSE,save_path="")
}
\arguments{
\item{source_description}{Description of the file from which the data is to be imported. The specification of the description is usually just the path and file name of the file.}

\item{wf}{Object or a character string representing the name of an `EViews` workfile.}

\item{type}{Optional. Specify the file type, it can values allowed by `EViews` \code{import} commands like \code{access}, \code{text}. For the most part, you should not need to specify a “type=” option as EViews will automatically determine the type from the filename.}

\item{options}{Optional.Specify the `EViews` \code{options} for \code{import} command like \code{resize}, \code{link}, \code{page=page_name}.}

\item{smpl_string}{Optional. Specify the sample to be used for the data import.}

\item{genr_string}{Optional. Any valid `EViews` series creation expression to be used to generate a new series in the workfile as part of the import procedure.}

\item{rename_string}{Optional. Pairs of old object names followed by the new name to be used to rename some of the imported series.}

\item{frequency}{Object or a character string representing the frequency of a workfile page to be created. Only letters accepted by EViews are allowed. For example \code{u} for undated, \code{a} for annual, \code{m} for monthly and so on.}

\item{start_date}{Object or a character string representing the \code{start date}. It should be left blank for undated (when the \code{frequency} is \code{u}).}

\item{id}{Name of `EViews` ID series. Required for `EViews` \code{Match-Merge Import}.}

\item{destid}{Name of the destination ID.  Required for `EViews` \code{Match-Merge Import}.}

\item{append}{Logical, whether to append to the bottom of the `EViews` workfile page or not.}

\item{save_path}{Specify the path to save the `Eviews` workfile}
}
\value{
An EViews workfile
}
\description{
Use this function to import data to `EViews` workfile from R
}
\examples{
library(EviewsR)
\dontrun{
x=runif(100); y=runif(100); data=data.frame(x,y);write.csv(data,"eviewsr.csv",row.names = FALSE)

eviews_import(source_description = "eviewsr.csv",start_date = "1990",frequency = "m",
rename_string = "x ab",smpl_string = "1990m10 1992m10")
}
}
\seealso{
eng_eviews, exec_commands, eviews_graph, eviews_import, create_object, eviews_pagesave, rwalk, eviews_wfcreate, eviews_wfsave, export, import_table, import
}
\keyword{documentation}
