% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EN_GetProfile.R
\name{EN_GetProfile}
\alias{EN_GetProfile}
\title{Retrieve the profile (characteristics) of a specified Equity, Index, Fund, ETF, or Bond listed on Euronext.}
\usage{
EN_GetProfile(ticker, stock_type = "Eq_Ind")
}
\arguments{
\item{ticker}{A character string representing the Stock's or an Index's ticker, name, or ISIN.}

\item{stock_type}{The type of the ticker: 'Eq_Ind' for Stocks and Indexes, 'Fund' or "F" for Fund tickers, 'Bond' or "B" for Bond tickers, and 'Etfs' or "E" for EFTs.}
}
\value{
A List (Name, ISIN, DNA, Symbol) representing the DNA of the Stock or an Index.
}
\description{
This function retrieves the characteristic elements of a a Stock, Index, Etfs, Fund or Bond listed on Euronext
using the provided Symbol/Name/ISIN or DNA.
}
\examples{

library(httr)
library(jsonlite)
library(rvest)
library(stringr)
library(magrittr)

# Note: For Equity, Index, Fund, and ETF, provide the giving Symbol, ISIN,
# Name, or DNA for best results, but for a Bond, provide its DNA and
# sometimes its Name for best results because a company or country
# can issue more than one Bond.

## Equities
# Example a : '3D SYSTEMS CORP' equity
EN_GetProfile("4ddd")  # By providing Symbol

# Example b : 'ALFEN' equity
EN_GetProfile("NL0012817175") # By providing ISIN

# Example c : 'LES HOTELS BAVEREZ' equity
EN_GetProfile("LES HOTELS BAVEREZ") # By providing Name

# Example d : 'BE SEMICONDUCTOR' equity
EN_GetProfile("NL0012866412-XAMS") # By providing DNA

## Indices
# Example a : 'AEX CONS STAPL GR' Index
EN_GetProfile("NLCSG") # By providing Symbol

# Example b : 'AEX All-Share Index' Index
EN_GetProfile("NL0000249100") # By providing ISIN

# Example c : 'Euronext Core Europe 30 EW Decrement 5\% NR' Index
EN_GetProfile("EN CE EW30 D 5\% NR") # By providing Name

# Example d : 'SBF 120 NR' Index
EN_GetProfile("QS0011131842-XPAR") # By providing DNA

\donttest{

# Funds
# Example a : 'ACOMEA PERFORMANCE' Fund
EN_GetProfile("ACAPER", stock_type = 'F') # By providing Symbol

# Example b : 'BNP ESGNL' Fund
EN_GetProfile("BNP ESGNL", stock_type = 'F') # By providing Name

# Example c : 'SWIF2' Fund
EN_GetProfile("NL0015000W40", stock_type = 'F') # By providing ISIN of SWIF2

# Example d : 'GOLDMAN SACHS PARAPLUFONDS 2 N' Fund
EN_GetProfile("NL0000293181-XAMS", stock_type = 'F') # By providing DNA of GSDM5


## ETFs
# Example a : 'Asia IG Corp US A' Etf
EN_GetProfile("$Asia IG Corp US A", stock_type = 'E') # By providing Name

# Example b : '1X MSFT' Etf
EN_GetProfile("MSFT", stock_type = 'E') # By providing Symbol

# Example c : '3X LONG COINBASE' Etf
EN_GetProfile("XS2399367254", stock_type = 'E') # By providing ISIN of 3X LONG COINBASE

# Example d : '3X PLTR' Etf
EN_GetProfile("XS2663694680-XAMS", stock_type = 'E') # By providing DNA


# Examples for Bonds
# Example a: 'A2A SLB TF 0,625\%' Bond
EN_GetProfile("XS2364001078-XMOT", stock_type = 'B') # By providing DNA

# Example b: 'AAB1.50\%30SEP30' Bond
EN_GetProfile("AAB1.50\%30SEP30", stock_type = 'B') # By providing Name
}

}
