% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/key_functions.R
\encoding{UTF-8}
\name{uniform_key}
\alias{uniform_key}
\title{Uniform key function}
\usage{
uniform_key(x, w)
}
\arguments{
\item{x}{vector of perpendicular distances from the transect.}

\item{w}{half width of the strip transect.}
}
\value{
A numeric value corresponding to a given value of \code{x} and
\code{w}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function provides the uniform key function for model fitting in
distance sampling.
}
\details{
This is the uniform key function with parameter
\code{sigma}. Its expression is given by

\eqn{g(x) = \frac{1}{w},}

for x > 0.
}
\examples{
library(EstimationTools)

#----------------------------------------------------------------------------
# Example: Uniform function
uniform_key(x=1, w=100)
curve(uniform_key(x, w=100), from=0, to=10, ylab='g(x)')

#----------------------------------------------------------------------------
}
\seealso{
Other key functions: 
\code{\link{half_norm_key}()},
\code{\link{hazard_rate_key}()}
}
\author{
Jaime Mosquera Gutiérrez, \email{jmosquerag@unal.edu.co}
}
\concept{key functions}
