% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estim_diagnostics.R
\name{estims_boxplot}
\alias{estims_boxplot}
\title{Boxplot of estimates}
\usage{
estims_boxplot(data, sep = FALSE)
}
\arguments{
\item{data}{data frame returned by \code{\link{Estim_diagnost}}}

\item{sep}{indicates whether all plots will be stacked together or returned as elements of a list}
}
\value{
ggplot2 object
}
\description{
Plot boxplots of estimators for different sample sizes.
}
\examples{
Nmc=400
s<-seq(from = 1, to = 10, by = 2)*1e3
Inference<-function(s){
rrr<-rnorm(n=s)
list(Mn=mean(rrr), Sd=sd(rrr))
}

data <- Estim_diagnost(Nmc, s, Inference)
estims_boxplot(data)

estims_boxplot(data, sep=TRUE)
}
