% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect_distfit.R
\name{expect_mean_equal}
\alias{expect_mean_equal}
\title{Test a mean-value using t-test}
\usage{
expect_mean_equal(p_value = 0.001, ...)
}
\arguments{
\item{p_value}{threshold p-value of the test}

\item{...}{parameters to pass to t.test function including data sample(s)}
}
\value{
Invisibly returns a p-value of the test
}
\description{
Expectation checking whether values from a given sample have a certain mean or that two samples have the same mean. The underlying procedure is Student's t-test \code{\link[stats]{t.test}}.
The expectation throws an error when the test's p-value is smaller than the threshold p-value.
}
\examples{
# This test doesn't pass
\dontrun{
x<-1:1e3
expect_mean_equal(x=x)
}

# This one passes, but shouldn't
x<-rnorm(1e3) + 0.01
expect_mean_equal(x=x)

x<-rnorm(1e3)
expect_mean_equal(x=x)

# check if 2 samples have the same mean
x<-rnorm(1e3, mean=10)
y<-rnorm(1e3, mean=10)
expect_mean_equal(x=x, y=y)
}
