% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{studyPeriod}
\alias{studyPeriod}
\title{Compute the study period}
\usage{
studyPeriod(input)
}
\arguments{
\item{input}{list of parameters as defined in the Signal Detection Application (see \code{\link{runEpiSDApp}})

(i.e.  \code{list(disease, country, indicator, stratification, unit, daterange, algo, testingperiod)})}
}
\value{
Dataframe including the complete time series with no gaps:
\item{StudyPeriod}{approximated daily date e.g. \code{2010-01-01}}
\item{Time}{exact date in the format according to the time unit parameter e.g. \code{2010-01}}
}
\description{
Compute a dataframe including two types of dates corresponding
to the study period defined in the list of parameters \code{input} \cr
(i.e. \code{StudyPeriod} = approximated daily date; \code{Time} = exact date in the format according to the time unit parameter)
}
\examples{
#-- Setting the parameters to run the report for
input <- list(
disease = "Salmonellosis",
country = "EU-EEA - complete series",
indicator = "Reported cases",
stratification = "Confirmed cases",
unit = "Month",
daterange = c("2010-01-01", "2016-12-31"),
algo = "FarringtonFlexible",
testingperiod = 5
)

StudyPeriod <- studyPeriod(input)
head(StudyPeriod)

}
