% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBarGroupedH.R
\name{plotBarGroupedH}
\alias{plotBarGroupedH}
\title{Horizontal grouped bar graph}
\usage{
plotBarGroupedH(
  .data,
  xvar = "",
  xlabel = "",
  yvar = "",
  ylabel = "",
  group = "",
  fill_color = EcdcColors(col_scale = "qual", n = length(unique(.data[[group]]))),
  log10_scale = FALSE
)
}
\arguments{
\item{.data}{dataframe containing the variables to plot}

\item{xvar}{character string, name of the categorical variable to plot on the x-axis in quotes}

\item{xlabel}{character string, label of the x axis}

\item{yvar}{character string, name of the numerical variable to plot on the y-axis in quotes}

\item{ylabel}{character string, label of the y axis}

\item{group}{character string, name of the grouping variable in quotes, e.g. gender.}

\item{fill_color}{character string, hexadecimal colour to use in the graph;
(default to ECDC green \code{"#65B32E"}, see \code{EcdcColors(col_scale = "qual", n = 1))}}

\item{log10_scale}{boolean, TRUE if y-axis should be log scale
(default \code{FALSE} ,see \code{ggplot2::scale_y_log10})}
}
\description{
This function draws an horizontal bar graph of the values of variable 'Yvar'
with the categorical variable 'Xvar' on the x-axis. \cr
Expects aggregated data.
}
\examples{
# --- Create dummy data
mydat <- data.frame(Gender=c("F", "F", "M", "M"),
                    AgeGroup = c("0-65", "65+", "0-65", "65+"),
                    NumberOfCases = c(54,43,32,41))

# --- Plot the dummy data
plotBarGroupedH(mydat,
              xvar = "AgeGroup",
              xlabel = "Age",
              yvar = "NumberOfCases",
              ylabel = "Number of cases",
              group = "Gender")

}
\seealso{
Internal function: \code{\link{EcdcColors}} \cr
Required Packages: \code{\link{ggplot2}}
}
\keyword{bargraph}
