% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise.R
\name{calc_summary_measures}
\alias{calc_summary_measures}
\title{Calculate All Summary Measures}
\usage{
calc_summary_measures(
  samples,
  summarise_by = NULL,
  order_by = NULL,
  CrIs = c(0.2, 0.5, 0.9)
)
}
\arguments{
\item{samples}{A data.table containing at least a value variable}

\item{summarise_by}{A character vector of variables to group by.}

\item{order_by}{A character vector of parameters to order by, defaults to all \code{summarise_by}
variables.}

\item{CrIs}{Numeric vector of credible intervals to calculate.}
}
\value{
A data.table containing summary statistics by group.
}
\description{
Calculate summary statistics and credible intervals from a data frame by group.
}
\examples{
samples <- data.frame(value = 1:10, type = "car")
# default
calc_summary_measures(samples)
#  by type
calc_summary_measures(samples, summarise_by = "type")
}
