% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/steepness_precis.R
\name{steepness_precis}
\alias{steepness_precis}
\title{numeric summary of steepness}
\usage{
steepness_precis(x, quantiles = c(0.055, 0.25, 0.75, 0.945))
}
\arguments{
\item{x}{result from \code{\link{elo_steepness_from_matrix}},
\code{\link{elo_steepness_from_sequence}} or
\code{\link{davids_steepness}}}

\item{quantiles}{numeric, the quantiles to be returned}
}
\value{
a data.frame with one row providing a summary of the
steepness posterior
}
\description{
numeric summary of steepness
}
\examples{
data(dommats, package = "EloRating")

res <- elo_steepness_from_matrix(dommats$elephants, n_rand = 1, iter = 1000,
                                 silent = TRUE, refresh = 0)
steepness_precis(res)
}
