% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_steepness_regression.R
\name{plot_steepness_regression}
\alias{plot_steepness_regression}
\title{plot steepness regression}
\usage{
plot_steepness_regression(
  x,
  adjust = 3,
  color = TRUE,
  width_fac = 0.1,
  axis_extend = 0.1
)
}
\arguments{
\item{x}{result from \code{\link{elo_steepness_from_matrix}},
\code{\link{elo_steepness_from_sequence}} or
\code{\link{davids_steepness}}}

\item{adjust}{numeric, parameter for smoothing posterior of individual scores}

\item{color}{logical, default is \code{TRUE} where individuals get color-
coded. If \code{FALSE}: a gray scale is used. It is also possible
to hand over a vector with colors, which then must be correspond
in length to the number of individuals.}

\item{width_fac}{numeric, relative width of posterior distributions. This is
actually affects the 'height' but since the posteriors are rotated it
visually represents width.}

\item{axis_extend}{numeric, an extension factor to extend the horizontal
axis to leave space for the posteriors. When set to 0 the axis stops
at \emph{n} (the number of individuals, which represents the
lowest rank).}
}
\value{
a plot
}
\description{
visually combine individual scores with group-level steepness
}
\examples{
data("bonobos", package = "EloRating")
res <- davids_steepness(bonobos, refresh = 0, iter = 1000)
plot_steepness_regression(res, width_fac = 0.5)
}
