% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomsequence.R
\name{randomsequence}
\alias{randomsequence}
\title{random dominance interaction sequence}
\usage{
randomsequence(
  nID = 10,
  avgIA = 20,
  startdate = as.Date("2000-01-01"),
  alphabet = TRUE,
  reversals = 0.1,
  ties = NULL,
  presence = NULL
)
}
\arguments{
\item{nID}{integer, number of IDs, must be less than 2601}

\item{avgIA}{numeric, average number of interactions an individual is involved in}

\item{startdate}{character, a start date, by default \code{"2000-01-01"}}

\item{alphabet}{logical, should the individual within an interaction that comes first in alphabetical order be the winner? By default \code{TRUE}, which gives some orderliness in the hierarchy}

\item{reversals}{numeric, proportion of interactions that ends in reversed outcomes, i.e. the initial winner (if \code{alphabet=TRUE) the first according to alphanumeric order}) is changed into the loser. By default \code{0.1}}

\item{ties}{numeric, proportion of interactions that ends undecided}

\item{presence}{numeric vector of length 2. The first value indicates what proportion of individuals are absent for some time. The second value indicates the proportion of time (days) these individuals are absent}
}
\value{
an object of class \code{randomsequence}, which is a list with the following items:
\item{seqdat}{an interaction sequence}
\item{pres}{a presence matrix, actually a \code{data.frame}}
}
\description{
create a random dominance sequence for testing or simulations
}
\examples{
IA <- randomsequence()
SEQ <- elo.seq(winner = IA$seqdat$winner, loser = IA$seqdat$loser, Date = IA$seqdat$Date,
               runcheck = FALSE, progressbar = FALSE)
stab_elo(SEQ)
#
IA <- randomsequence(presence = c(0.5, 0.5))
SEQ <- elo.seq(winner = IA$seqdat$winner, loser = IA$seqdat$loser, Date = IA$seqdat$Date,
               presence = IA$pres, runcheck = FALSE, progressbar = FALSE)
stab_elo(SEQ)

}
\author{
Christof Neumann
}
