% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optistart.R
\name{optistart}
\alias{optistart}
\title{optimize start values}
\usage{
optistart(eloobject, burnin = 0, spread = 200, runs = 2000,
  doplot = FALSE, initialcohort = TRUE)
}
\arguments{
\item{eloobject}{output from \code{\link{elo.seq}}}

\item{burnin}{numeric, the number of interactions to be excluded from the calculation of the (log) likelihood. This parameter is ignored if a date range is supplied. By default \code{burnin = 0}, i.e. all interactions are considered.}

\item{spread}{numeric, the standard deviation of the ratings to be tested (by default 200)}

\item{runs}{numeric, number of inital ratings to be tested (by default 2000)}

\item{doplot}{logical, should the distribution of log likelihoods be plotted}

\item{initialcohort}{logical, not yet implemented}
}
\value{
a list with multiple items:

the item \code{$best} reflects the optimal start values found
}
\description{
experimental function to test different sets of randomly selected start values
}
\examples{
set.seed(123)
xdata <- randomsequence(8, 100)$seqdat
res1 <- elo.seq(xdata$winner, xdata$loser, xdata$Date)
ores <- optistart(res1)
res2 <- elo.seq(xdata$winner, xdata$loser, xdata$Date, startvalue = ores$best)
eloplot(res1)
eloplot(res2)
}
