% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getItems.R
\name{getAllItems}
\alias{getAllItems}
\title{Retrieve IRT Item Variable Names}
\usage{
getAllItems(sdf, construct = NULL)
}
\arguments{
\item{sdf}{an \code{edsurvey.data.frame} or \code{light.edsurvey.data.frame} containing IRT information. Supports NAEP and TIMSS 2011, 2015, and 2019 studies only.}

\item{construct}{a character value (or vector) for which to return the associated item variable names. Default value is \code{NULL} which returns all IRT item variable names.
Use the \code{showPlausibleValues} function to view construct details.}
}
\value{
a character vector of the items names associated for the values in \code{construct}.
}
\description{
Retrieves the IRT item variable names associated with construct names for use with \code{mml.sdf} function.
}
\note{
if \code{construct} is a vector, all item names will be returned for those constructs. Use \code{getAllItems} with \code{getData} when creating a \code{light.edsurvey.data.frame}, see example for use.
}
\examples{
\dontrun{
  #TIMSS Example
  t15 <- readTIMSS(path="~/TIMSS/2015", "usa", 4)
  
  showPlausibleValues(data=t15) #view constructs in console
  
  #ensure we have all data needed for mml.sdf on light.edsurvey.data.frame
  #must be specified ahead of time.  the 'getAllItems' function makes this easy
  mathItems <- getAllItems(sdf=t15, construct="mmat") #get mathematics items
  sciItems <- getAllItems(sdf=t15, construct="ssci") #get science items
  allItems <- getAllItems(sdf=t15, construct="NULL")
  
  wgtVar <- "totwgt"
  psustr <- c(getPSUVar(t15, wgtVar), getStratumVar(t15, wgtVar))
  lsdf <- getData(data=t15,
                  varnames=c("ROWID", "mmat", mathItems, psustr, wgtVar),
                  omittedLevels=FALSE,
                  addAttributes=TRUE) #builds light.edsurvey.data.frame
  
  #as a light.edsurvey.data.frame all elements must be present
  mml.sdf(formula=mmat ~ 1, data=lsdf, weightVar="totwgt")
  
  #as edsurvey.data.frame elements retrieved automatically for user
  mml.sdf(formula=mmat ~ 1, data=t15, weightVar="totwgt") 
  
  #NAEP example
  sdf <- readNAEP(path=system.file("extdata/data", "M36NT2PM.dat", package="NAEPprimer"))
  
  allItems <- getAllItems(sdf=sdf, construct=NULL)
  algebraItems <- getAllItems(sdf=sdf, construct="algebra")
}
}
\seealso{
\code{\link{mml.sdf}}
}
\author{
Tom Fink, Sun-Joo Lee, Eric Buehler, and Paul Bailey
}
