% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchSDF.R
\name{searchSDF}
\alias{searchSDF}
\title{EdSurvey Codebook Search}
\usage{
searchSDF(string, data, fileFormat = NULL, levels = FALSE)
}
\arguments{
\item{string}{a vector of character strings to search for in the database connection object (\code{data}).
The function will search the codebook
for a matching character string using regular expressions. When a
string has several elements, all must be present for a 
variable to be returned.}

\item{data}{an \code{edsurvey.data.frame}, a \code{light.edsurvey.data.frame}, or
an \code{edsurvey.data.frame.list}}

\item{fileFormat}{a character vector indicating the data source to search for variables.
The default \code{NULL} argument searches all codebooks.}

\item{levels}{a logical value; set to \code{TRUE} to return a snapshot of the levels in
an \code{edsurvey.data.frame}}
}
\value{
a \ifelse{latex}{\code{data.frame}}{\code{\link[base]{data.frame}}} that shows the variable names, labels,
                  and levels (if applicable) from an \code{edsurvey.data.frame} or a \code{light.edsurvey.data.frame} based on a matching character string
}
\description{
Retrieves variable names and labels for an \code{edsurvey.data.frame}, 
a \code{light.edsurvey.data.frame}, or an \code{edsurvey.data.frame.list}
using character string matching.
}
\examples{
\dontrun{
# read in the example data (generated, not real student data)
sdf <- readNAEP(system.file("extdata/data", "M36NT2PM.dat", package="NAEPprimer"))

# search both the student and school files by a character string
searchSDF(string="book", data=sdf)

# use the `|` (OR) operator to search several strings simultaneously
searchSDF(string="book|home|value", data=sdf)

# use a vector of strings to search for variables that contain multiple strings,
# such as both "book" and "home"
searchSDF(string=c("book","home"), data=sdf)

# search only the student files by a character string
searchSDF(string="algebra", data=sdf, fileFormat="student")

# search both the student and school files and return a glimpse of levels
searchSDF(string="value", data=sdf, levels=TRUE)

# save the search as an object to return a full data.frame of search
ddf <- searchSDF(string="value", data=sdf, levels=TRUE)
ddf
}
}
\author{
Michael Lee and Paul Bailey
}
