% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Synthetic_Data.R
\name{SyntheticData}
\alias{SyntheticData}
\title{Create synthetic gaussian-shaped species abundance data}
\usage{
SyntheticData(SpeciesNum, CommunityNum, Length = 100, SpCo = NULL,
  Parameters = list(a = NULL, b = NULL, c = NULL), dev.a = 10,
  dev.b = 10, dev.c = 0, down.limit = 1, pal = NULL,
  xlab = "Gradient", ylab = "Synthetic species",
  title = "Synthetic data")
}
\arguments{
\item{SpeciesNum}{An integer giving the total number of species in the
synthetic data.}

\item{CommunityNum}{An integer giving the number of communities to be
synthetised.}

\item{Length}{The lenght of the gradient. Corresponds to the x-axis in a
plot.}

\item{SpCo}{The ratio of species per communities. If NULL, species will be
spread evenly between communities with additional species in the last
community if the quotient is not an integer. When specified, SpCo must be a
vector of lenght equal to CommunityNum and whose sum is equal to SpeciesNum}

\item{Parameters}{A list containing the parameters (a, b and c) for the
gaussians. Each parameter must be specified for each community. See
Details.}

\item{dev.a}{The deviation around parameter a for the gaussian in a
community. If 0 all species curve in the comunity will have the same a
parameter.}

\item{dev.b}{The deviation around parameter b for the gaussian in a
community. If 0 all species curve in the comunity will have the same b
parameter.}

\item{dev.c}{The deviation around parameter a for the gaussian in c
community. If 0 all species curve in the comunity will have the same c
parameter.}

\item{down.limit}{The limit under which the gaussian curve will be rounded
down to 0. The default is 1.}

\item{pal}{The color palette to be used. Species curves are colored according
to communities. Either a colorspace palette or a vector of the same lenght
as the number of species.}

\item{xlab}{A title for the x-axis. See plot.}

\item{ylab}{A title for the y-axis. See plot.}

\item{title}{An overall title for the plot. See plot.}
}
\value{
SyntheticData returns a dataset with numbered species (sp.1, sp.2,
  ...) as columns. It also plot the obtained data.
}
\description{
Create synthetic gaussian-shaped species abundance data
}
\details{
The SyntheticData function is intended for the creation of
  articficial dataset to test ecological patterns along gradients. The
  gaussian curves that it computes are of the form: \eqn{
  a*exp(-(((x-b)^2)/2*(c^2))) } The parameters can be interpreted as follow:
  a is the maximum height of the gaussian on the y-axis, b is the center of
  the gaussian on the x-axis and c is the steepness of the slopes on each
  side of the maximum. The gaussians create a set of continuous data that are
  akin to abundances. As gaussians of this type cannot reach 0, any value
  that is below the down.limit (default is 1) is rounded down to 0.
}
\examples{
### 3 distinct communities comprising a total of 21 species
SyntheticTrial <- SyntheticData(SpeciesNum = 21, CommunityNum = 3,
                                SpCo = NULL, Length = 500,
                                Parameters = list(a=rep(60, 3),
                                                  b=c(0,250,500),
                                                  c=rep(0.03,3)),
                                pal = c("#008585", "#FBF2C4", "#C7522B"))

### 3 distinct communities with uneven species numbers
SyntheticTrial <- SyntheticData(SpeciesNum = 21, CommunityNum = 3,
                                SpCo = c(5, 10, 6), Length = 500,
                                Parameters = list(a=rep(60, 3),
                                                  b=c(0,250,500),
                                                  c=rep(0.03,3)),
                                pal = c("#008585", "#FBF2C4", "#C7522B"))




}
