% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eco.split.R
\name{eco.split}
\alias{eco.split}
\title{Splitting an ecogen object by groups}
\usage{
eco.split(eco, hier, name = NULL, overwrite = FALSE, missing = c("0",
  "NA", "MEAN"), asList = TRUE)
}
\arguments{
\item{eco}{Object of class "ecogen".}

\item{hier}{The name of the S slot column with labels assigning individuals to groups.}

\item{name}{Name used for the output objects. Default is the name of the input,followed by
a suffix (see Description).}

\item{overwrite}{Overwrite files in workspace with same name if exist?
Missing elements are treated as zeros in the default option.}

\item{missing}{Missing data argument This can take three values ("0", "NA" or "MEAN"),
as described in  \code{\link{ecogen}}.}

\item{asList}{Return a list with the objects instead of creating objects in workspace?
Default = TRUE}
}
\description{
The function splits an ecogen objects into the groups of a hierarchy
contained in the slot S. If asList is TRUE,a list with the objects is created , 
that can be assigned to a name with regular rules, using the operator "<-". 
Else, the function creates one ecogen object for each level in the workspace
with the following nomenclature: <name of ecogen object>.<name of hierarchical level>.
}
\examples{
\dontrun{
data(eco3)
eco3
#list of objects
x <- eco.split(eco3, "structure", asList = TRUE)
#r-ebinding
eco.bind <- eco.rbind(x)
# note that different subsets can also be created
S1.3 <- eco.rbind(x[[1]], x[[3]])

# split and create objects with prefix "eco3"
eco.split(eco3,"structure", asList = FALSE) 
# split and create objects with prefix "newObjects"
eco.split(eco3,"structure", "newObjects", asList = FALSE) 



}

}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}

