% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/eco.sort.R
\name{eco.sort}
\alias{eco.sort}
\title{Ordering cells in a data frame or matrix}
\usage{
eco.sort(x, ndig)
}
\arguments{
\item{x}{object to order.}

\item{ndig}{Number of digits coding each allele (e.g. 2: xx, or 3: xxx).}
}
\description{
This program returns a data fame with ordered cells.
For example, in the case of a G data frame, the program return a data frame with the cells
of each individual \emph{i} and each loci \emph{j} in ascending order,
i.e., a locus of type 51 is returned as 15.
}
\examples{
\dontrun{
data(eco.test)
eco <- ecogen(XY = coordinates, P = phenotype, G = genotype,
E = environment, S = as.data.frame(structure), missing = 0)
eco$G
eco <- eco.sortalleles(eco, 1)
eco$G
}
}
\author{
Leandro Roser \email{leandroroser@ege.fcen.uba.ar}
}

