% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscrepancyPrior-IndLTPrior-class.R
\docType{class}
\name{IndLTPrior-class}
\alias{IndLTPrior-class}
\title{A class to hold the priors for the ensemble model.}
\description{
An \code{IndLTPrior} object encapsulates the prior information for the long-term discrepancies of the individual simulators within the ensemble model.
}
\details{
Individual long-term discrepancies \eqn{\gamma_k} are drawn from a distribtion \deqn{\gamma_k \sim N(0, C_\gamma).} Accepted parametrisation forms for this discrepancy are \code{lkj}, \code{beta}, or \code{inv_wishart}. See details of the \code{EnsemblePrior()} constructor for more details.
}
\section{Slots}{

\describe{
\item{\code{parametrisation_form}}{The parametrisation by which the covariance matrix of the noise of the AR process is decomposed.}

\item{\code{var_params}}{The parameters characterising the variance of the distribution of the individual long-term discrepancy.}

\item{\code{cor_params}}{The parameters characterising the correlations of the distribution of the individual long-term discrepancy.}
}}

\seealso{
\code{\linkS4class{IndSTPrior}}, \code{\linkS4class{ShaSTPrior}}, \code{\linkS4class{TruthPrior}},
}
