% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot.EnsembleSample}
\alias{plot.EnsembleSample}
\title{Plot the ensemble output}
\usage{
\method{plot}{EnsembleSample}(x, variable = NULL, quantiles = c(0.05, 0.95), ...)
}
\arguments{
\item{x}{An \code{EnsembleSample} object.}

\item{variable}{The name of the variable to plot. This can either be a \code{character} string in the same form as the observation variable, or an index for the column in the observations data frame.}

\item{quantiles}{A \code{numeric} vector of length 2 giving the quantiles for which to plot ribbons if doing a full sampling of the ensemble model. The default is \code{c(0.05,0.95)}.}

\item{...}{Other arguments passed on to methods. Not currently used.}
}
\value{
The \code{ggplot} object.
}
\description{
Plots the latent variables predicted by the ensemble model, along with simulator outputs and observations.
}
\examples{
\donttest{
fit <- fit_ensemble_model(observations = list(SSB_obs, Sigma_obs),
                         simulators = list(list(SSB_ewe, Sigma_ewe, "EwE"),
                                           list(SSB_fs,  Sigma_fs, "FishSUMS"),
                                           list(SSB_lm,  Sigma_lm, "LeMans"),
                                           list(SSB_miz, Sigma_miz, "Mizer")),
                         priors = EnsemblePrior(4))
samples <- generate_sample(fit)
plot(samples)
plot(samples, variable = "Cod", quantiles=c(0.2, 0.8))


fit_point <-fit_ensemble_model(observations = list(SSB_obs, Sigma_obs),
                              simulators = list(list(SSB_ewe, Sigma_ewe, "EwE"),
                                           list(SSB_fs,  Sigma_fs, "FishSUMS"),
                                           list(SSB_lm,  Sigma_lm, "LeMans"),
                                           list(SSB_miz, Sigma_miz, "Mizer")),
                               priors = EnsemblePrior(4),
                               full_sample = FALSE)
samples1 <- generate_sample(fit_point)
plot(samples1, variable="Herring")
}
}
