% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelFunctions.R
\name{haploCrossMatrix}
\alias{haploCrossMatrix}
\title{Haplotype crossing matrix generation}
\usage{
haploCrossMatrix(genomeObj)
}
\arguments{
\item{genomeObj}{a \code{Genome} object}
}
\value{
An haplotype crossing matrix.
}
\description{
Generation of the haplotype crossing matrix associated to a \code{Genome}
object.
}
\details{
A crossover matrix is a square matrix of size equal to the number of
haplotypes. It describes for each combination of two gametic haplotypes
the genotype index resulting from their syngamy. In the general case it
is not a symmetrical matrix (it is if a single haploid locus with a single
allele is defined), because the transmission of haploid loci is only
maternal, therefore non-symmetrical as is the transmission of diploid
loci. It is therefore necessary to enter the haplotype frequencies of
male gametes in the columns and the haplotype frequencies of female
gametes in the rows during the calculations (this is done in the
simulations).
}
\author{
Ehouarn Le Faou
}
