% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biases.R
\name{multi_bias}
\alias{multi_bias}
\title{Create a set of biases for a multi-bias sensitivity analysis}
\usage{
multi_bias(..., verbose = TRUE)
}
\arguments{
\item{...}{Biases (\code{\link[=confounding]{confounding()}}, \code{\link[=selection]{selection()}}, and/or
\code{\link[=misclassification]{misclassification()}}), each possibly including arguments specifying more
detail about the bias of interest. Selection and confounding should be
listed in the order in which they affect the data (see \href{../articles/multiple-bias.html#ordering-of-the-biases}{ordering of the biases})}

\item{verbose}{Logical. If \code{TRUE}, returns warnings and messages immediately.
Defaults to \code{TRUE}.}
}
\value{
Invisibly returns a list with components whose values depend on the
options chosen: \code{n} (the degree of the polynomial in the numerator), \code{d}
(the degree of the polynomial in the denominator), \code{m} (the parameters in
the bias factor), \code{mess} (any messages/warnings that should be printed for
the user), and \code{bias}("misclassification").
}
\description{
Multiple biases (\code{\link[=confounding]{confounding()}}, \code{\link[=selection]{selection()}}, and/or
\code{\link[=misclassification]{misclassification()}}) can be assessed simultaneously after creating a
\code{multi_bias} object using this function.
}
\examples{
biases <- multi_bias(confounding(),
                     selection("general"))

# print() lists the arguments for the multi_bound() function
print(biases)

# summary() provides more information
# with parameters in latex notation if latex = TRUE
summary(biases, latex = TRUE)

# Calculate a bound
multi_bound(biases = biases,
            RRAUc = 1.5, RRUcY = 2, RRUsYA1 = 1.25,
            RRSUsA1 = 4, RRUsYA0 = 3, RRSUsA0 = 2)
}
\keyword{multi-bias}
