% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enmtools.vip.R
\name{enmtools.vip}
\alias{enmtools.vip}
\title{Takes an enmtools.model object, and performs variable importance analyses on it using methods from the vip package}
\usage{
enmtools.vip(
  model,
  metric = "auc",
  nsim = 10,
  method = "permute",
  verbose = FALSE,
  ...
)
}
\arguments{
\item{model}{An enmtools.model object}

\item{metric}{The metric to use for measuring how variables affect model predictions}

\item{nsim}{The number of simulations to be run for method "permute"}

\item{method}{A character string or vector containing any combination of "model", "permute", "shap", or "firm".  For details on what these mean, see the vip package help.}

\item{verbose}{Controls printing of messages}

\item{...}{Further arguments to be passed to vip's "vi" functions.}
}
\value{
An enmtools.vip object
}
\description{
Takes an enmtools.model object, and performs variable importance analyses on it using methods from the vip package
}
\examples{
\donttest{
install.extras(repos='http://cran.us.r-project.org')
data(euro.worldclim)
data(iberolacerta.clade)
monticola.glm <- enmtools.glm(iberolacerta.clade$species$monticola,
                              env = euro.worldclim,
                              test.prop = 0.3)
enmtools.vip(monticola.glm)
}
}
