% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{sctr}
\alias{sctr}
\alias{sctr,binClst-method}
\alias{sctr,binClstStck-method}
\title{Clustering 2D-scatterplot}
\usage{
sctr(obj, ...)

\S4method{sctr}{binClst}(obj, ref = NULL, showVars = NULL,
  showClst = NULL, ...)

\S4method{sctr}{binClstStck}(obj, ref = NULL, showVars = NULL,
  showClst = NULL, ...)
}
\arguments{
\item{obj}{A \link{binClst_instance}.}

\item{...}{Parameters \code{ref}, \code{showVars} and \code{showClst} are
  optional.}

\item{ref}{A numeric vector with expert/reference labelling for visual validation of
  the clustering.

  A second \link{binClst_instance} to be compared with the former.}

\item{showVars}{When the number of variables is greater than two, a length 3
  numeric vector indicating one splitting variable and two variables to be
  scattered (given in that order).}

\item{showClst}{When the number of variables is greater than two, a numeric
  vector (of variable length) indicating a subset of the clusters that will
  be shown in the scatter plot. This is usefull in case of overlapping
  clusters.}
}
\description{
\code{sctr} generates a scatterplot from a
  \link{binClst_instance}, showing clusters in different colors.
}
\examples{
# -- apply EMbC to the example path --
mybcp <- stbc(expth,info=-1)
# -- show the scatterplot compared with expert labelling--
sctr(mybcp,expth$lbl)
}

