% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_SDT.R
\name{SDT}
\alias{SDT}
\title{Gaussian Signal Detection Theory Model for Binary Responses}
\usage{
SDT()
}
\value{
A model list with all the necessary functions to sample
}
\description{
Discrete binary choice based on continuous Gaussian latent, with no rt (rt
must be set to NA in data).
}
\details{
Model parameters are:
mean (unbounded)
sd (log scale) and
threshold (unbounded).

For identifiability in one condition two parameters must be fixed
(conventionally mean=0 and sd = 1). When used with data that records only
accuracy (so reponse bias cannot be evaluated) a single threshold must be
assumed and fixed (e.g., threshold = 0).

At present this model is not fully implemented in C, but as its likelihood
requires only pnorm evaluation it is quite fast.
}
\examples{
dprobit <- design(Rlevels = c("left","right"),
           factors=list(subjects=1,S=c("left","right")),
           formula=list(mean ~ 0+S, sd ~ 1,threshold ~ 1),
           matchfun=function(d)d$S==d$lR,
           constants=c(sd=log(1),threshold=0),
           model=SDT)

p_vector <- sampled_pars(dprobit)
}
