% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_funcs.R
\name{subset.emc}
\alias{subset.emc}
\title{Shorten an emc object}
\usage{
\method{subset}{emc}(
  x,
  stage = "sample",
  filter = NULL,
  thin = 1,
  keep_stages = FALSE,
  length.out = NULL,
  ...
)
}
\arguments{
\item{x}{an emc object}

\item{stage}{A character string. Indicates from which sampling stage(s) to take the samples from (i.e. \code{preburn}, \code{burn}, \code{adapt}, \code{sample})}

\item{filter}{Integer or numeric vector. If an integer is supplied, iterations
up until that integer are removed. If a vector is supplied, the iterations
within the range are kept.}

\item{thin}{An integer. By how much to thin the chains}

\item{keep_stages}{Boolean. If \code{TRUE}, will not remove samples from unselected stages.}

\item{length.out}{Integer. Alternatively to thinning, you can also select a
desired length of the MCMC chains, which will be thinned appropriately.}

\item{...}{additional optional arguments}
}
\value{
A shortened emc object
}
\description{
Shorten an emc object
}
\examples{
subset(samples_LNR, length.out = 10)
}
