\name{clustering.plot}
\alias{clustering.plot}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Clustering plots for one or two ways representation}
\description{
  Creates plots for a clustering analysis.
}
\usage{
clustering.plot(tree, tree.sup, data, lab, lab.sup,
dendro=TRUE, dendro.sup=TRUE, title="", scale="row", heatcol,
pdfname, names=TRUE, names.sup=TRUE, names.dist=TRUE,
trim.heatmap=1, palette="rainbow", legend=TRUE, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{tree}{an object of class 'agnes' representing the first clustering.}
  \item{tree.sup}{optional - an object of class 'agnes' representing the second clustering.}
  \item{data}{optional - expression data for the heatmap plot}
  \item{lab}{optional - a matrix of labels for 'tree' (by columns)}
  \item{lab.sup}{optional - a matrix of labels for 'tree.sup' (by columns)}
  \item{dendro}{display dendrogram of tree object - The default is TRUE}
  \item{dendro.sup}{display dendogram of tree.sup  object - The default is TRUE}
  \item{title}{optional - title of the graphic}
  \item{scale}{optional - character indicating if the values should be
    centered and scaled in either the row direction (gene) or the column
    direction (sample),or none. The default is '"row"'}
  \item{heatcol}{colors for the heatmap generated by myPalette}
  \item{pdfname}{optional - character string specifying the name of the pdf output}
  \item{names}{optional - if names=FALSE, the labels for 'tree' are not written - The default is TRUE}
  \item{names.sup}{optional - if names.sup=FALSE, the labels for 'tree.sup' are not written - The default is TRUE}
  \item{names.dist}{Display the distance used for the Hierachical Clustering - The default is TRUE}
  \item{trim.heatmap}{Percentile of the data to be trimmed. This helps to keep an informative color scale in the heatmap}
  \item{palette}{Palette used for color selection. see as.colors()}
  \item{legend}{Draw legend of the labels. Default is TRUE}
  \item{...}{Arguments to be passed to methods, such as graphical parameters (see 'par').}
}
\details{
  If the data matrix is specified, the function draws a clustering using the heatmap representation. If tree.sup is specified the function draws a two-ways clustering using the heatmap representation. Otherwise, a classical dendrogram is displayed.
 If a labels matrix is specified, each column of the matrix is represented under the dendrogram.
 If a pdfname is specified, the output is a pdf file.
 Setting 'trim.heatmap' to a number between 0 and 1 uses equidistant classes between the (trim.heatmap)- and (1-trim.heatmap)-quantile, and lumps the values below and above this range into separate open-ended classes. If the data comes from a heavy-tailed distribution, this can save the display from putting too many values into to few classes.
}


\author{EMA group}

\seealso{\code{\link{clustering}},  \code{\link{heatmap.plus}}}
\examples{
data(marty)

##Clustering on most variant genes
mv.genes<-genes.selection(marty, thres.num=100)
c.sample<-clustering(marty[mv.genes,], metric="pearson", metho="ward")
clustering.plot(c.sample, lab=marty.type.cl, title="H.Clustering\nPearson-Ward")

c.gene<-clustering(data=t(marty[mv.genes,]), metric="pearson",method="ward")

##Two-ways clustering
clustering.plot(tree=c.sample, tree.sup=c.gene, data=marty[mv.genes,], trim.heatmap=0.99)

}
\keyword{cluster}
