% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_function.R
\name{ELCICgee}
\alias{ELCICgee}
\title{Model selection based on ELCIC under the syntax of GEE (Main function).}
\usage{
ELCICgee(models, candidate.cor.sets,data, family,r,id,time)
}
\arguments{
\item{models}{A list of formulas. See the corresponding documentation to geeglm.}

\item{candidate.cor.sets}{A vector containing candidate correlation structures. It can be any subset of c("independence","exchangeable", "ar1").}

\item{data}{A data frame containing the variables in the model.}

\item{family}{A description of the error distribution and link function to be used in the model.
The details are given under "Details".}

\item{r}{A vector indicating the observation of data: 1 for observed records (both outcome and covariates are observed for a given subject), and 0 for unobserved records.
The default setup is that all data are observed.}

\item{id}{A vector indicating subject id.}

\item{time}{The number of observations in total for each subject.}
}
\value{
A list with two items: model selection result based on ELCIC;
An object of "geeglm" based on the selected model.
}
\description{
The function \code{\link{ELCICgee}} provides the model selection under the syntax of the geepack package.
}
\details{
Three commonly used distributions are considered: "gaussian", "poisson", "binomial".
For the current package, the identity link is considered for a "gaussian" distribution;
the log link is considered for a "poisson" distribution; the logit link is considered for a "binomial" distribution;
}
\examples{
## tests
# load data
data(geesimdata)
id<-geesimdata$id
r<-rep(1,length(id))
time<-3
dat <- data.frame(y=geesimdata$y, geesimdata$x,id=id)
models <- list(y~x1+x2)
candidate.cor.sets<-c("exchangeable")
family<-poisson()
output<-ELCICgee(models, candidate.cor.sets,data=dat,family,r,id,time)
output$model.selection
output$gee.output
}
