% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCIs.R
\name{plotHistogramTrend}
\alias{plotHistogramTrend}
\title{plotHistogramTrend}
\usage{
plotHistogramTrend(eList, eBoot, caseSetUp, flux = TRUE, xMin = NA,
  xMax = NA, xStep = NA, printTitle = TRUE, cex.main = 1.1,
  cex.axis = 1.1, cex.lab = 1.1, col.fill = "grey", ...)
}
\arguments{
\item{eList}{named list with at least the Daily, Sample, and INFO dataframes. Created from the EGRET package, after running \code{\link[EGRET]{modelEstimation}}.}

\item{eBoot}{named list. Returned from \code{\link{wBT}}.}

\item{caseSetUp}{data frame. Returned from \code{\link{trendSetUp}}.}

\item{flux}{logical if TRUE, plots flux results, if FALSE plots concentration}

\item{xMin}{minimum bin value, it is good to have the xMin and xMax arguments straddle zero.}

\item{xMax}{maximum bin value}

\item{xStep}{step size, should probably be multiples of 10 or 20}

\item{printTitle}{logical if TRUE, includes title}

\item{cex.main}{numeric title font size}

\item{cex.axis}{numeric axis font size}

\item{cex.lab}{numeric label font size}

\item{col.fill}{character fill color}

\item{\dots}{base R graphical parameters that can be passed to the hist function}
}
\description{
Histogram of trend.
}
\examples{
library(EGRET)
eList <- Choptank_eList
eBoot <- Choptank_eBoot
caseSetUp <- Choptank_caseSetUp
plotHistogramTrend(eList, eBoot, caseSetUp, flux=FALSE)

\dontrun{
caseSetUp <- trendSetUp(eList)
eBoot <- wBT(eList,caseSetUp)
plotHistogramTrend(eList, eBoot, caseSetUp,  
                   flux=FALSE, xSeq = seq(-20,60,5))
plotHistogramTrend(eList, eBoot, caseSetUp, 
                   flux=TRUE, xSeq = seq(-20,60,5))
}
}

