% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riEGA.R
\name{riEGA}
\alias{riEGA}
\title{Random-Intercept \code{\link[EGAnet]{EGA}}}
\usage{
riEGA(
  data,
  n = NULL,
  corr = c("auto", "cor_auto", "pearson", "spearman"),
  na.data = c("pairwise", "listwise"),
  model = c("glasso", "TMFG"),
  algorithm = c("leiden", "louvain", "walktrap"),
  uni.method = c("expand", "LE", "louvain"),
  estimator = c("auto", "WLSMV", "MLR"),
  plot.EGA = TRUE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{data}{Matrix or data frame.
Should consist only of variables to be used in the analysis.
\strong{Must} be raw data and not a correlation matrix}

\item{n}{Numeric (length = 1).
Sample size if \code{data} provided is a correlation matrix}

\item{corr}{Character (length = 1).
Method to compute correlations.
Defaults to \code{"auto"}.
Available options:

\itemize{

\item \code{"auto"} --- Automatically computes appropriate correlations for
the data using Pearson's for continuous, polychoric for ordinal,
tetrachoric for binary, and polyserial/biserial for ordinal/binary with
continuous. To change the number of categories that are considered
ordinal, use \code{ordinal.categories}
(see \code{\link[EGAnet]{polychoric.matrix}} for more details)

\item \code{"cor_auto"} --- Uses \code{\link[qgraph]{cor_auto}} to compute correlations. 
Arguments can be passed along to the function

\item \code{"pearson"} --- Pearson's correlation is computed for all 
variables regardless of categories

\item \code{"spearman"} --- Spearman's rank-order correlation is computed 
for all variables regardless of categories

}

For other similarity measures, compute them first and input them
into \code{data} with the sample size (\code{n})}

\item{na.data}{Character (length = 1).
How should missing data be handled?
Defaults to \code{"pairwise"}.
Available options:

\itemize{

\item \code{"pairwise"} --- Computes correlation for all available cases between
two variables

\item \code{"listwise"} --- Computes correlation for all complete cases in the dataset

}}

\item{model}{Character (length = 1).
Defaults to \code{"glasso"}.
Available options:

\itemize{

\item \code{"BGGM"} --- Computes the Bayesian Gaussian Graphical Model.
Set argument \code{ordinal.categories} to determine
levels allowed for a variable to be considered ordinal.
See \code{?BGGM::estimate} for more details

\item \code{"glasso"} --- Computes the GLASSO with EBIC model selection.
See \code{\link[EGAnet]{EBICglasso.qgraph}} for more details

\item \code{"TMFG"} --- Computes the TMFG method.
See \code{\link[EGAnet]{TMFG}} for more details

}}

\item{algorithm}{Character or 
\code{\link{igraph}} \code{cluster_*} function (length = 1).
Defaults to \code{"walktrap"}.
Three options are listed below but all are available
(see \code{\link[EGAnet]{community.detection}} for other options):

\itemize{

\item \code{"leiden"} --- See \code{\link[igraph]{cluster_leiden}} for more details

\item \code{"louvain"} --- By default, \code{"louvain"} will implement the Louvain algorithm using 
the consensus clustering method (see \code{\link[EGAnet]{community.consensus}} 
for more information). This function will implement
\code{consensus.method = "most_common"} and \code{consensus.iter = 1000} 
unless specified otherwise

\item \code{"walktrap"} --- See \code{\link[igraph]{cluster_walktrap}} for more details

}}

\item{uni.method}{Character (length = 1).
What unidimensionality method should be used? 
Defaults to \code{"louvain"}.
Available options:

\itemize{

\item \code{"expand"} --- Expands the correlation matrix with four variables correlated 0.50.
If number of dimension returns 2 or less in check, then the data 
are unidimensional; otherwise, regular EGA with no matrix
expansion is used. This method was used in the Golino et al.'s (2020)
\emph{Psychological Methods} simulation

\item \code{"LE"} --- Applies the Leading Eigenvector algorithm
(\code{\link[igraph]{cluster_leading_eigen}})
on the empirical correlation matrix. If the number of dimensions is 1,
then the Leading Eigenvector solution is used; otherwise, regular EGA
is used. This method was used in the Christensen et al.'s (2023) 
\emph{Behavior Research Methods} simulation

\item \code{"louvain"} --- Applies the Louvain algorithm (\code{\link[igraph]{cluster_louvain}})
on the empirical correlation matrix. If the number of dimensions is 1, 
then the Louvain solution is used; otherwise, regular EGA is used. 
This method was validated Christensen's (2022) \emph{PsyArXiv} simulation.
Consensus clustering can be used by specifying either
\code{"consensus.method"} or \code{"consensus.iter"}

}}

\item{estimator}{Character (length = 1).
Estimator to use for random-intercept model (see \href{https://lavaan.ugent.be/tutorial/est.html}{Estimators}
for more details).
Defaults to \code{"auto"}, which selects \code{"MLR"} for continuous data and
\code{"WLSMV"} for mixed and categorical data.
Data are considered continuous data if they have \code{8} or
more categories (see Rhemtulla, Brosseau-Liard, & Savalei, 2012).
To change this behavior, set \code{oridinal.categories} as an argument}

\item{plot.EGA}{Boolean (length = 1).
If \code{TRUE}, returns a plot of the network and its estimated dimensions.
Defaults to \code{TRUE}}

\item{verbose}{Boolean (length = 1).
Whether messages and (insignificant) warnings should be output.
Defaults to \code{FALSE} (silent calls).
Set to \code{TRUE} to see all messages and warnings for every function call}

\item{...}{Additional arguments to be passed on to
\code{\link[EGAnet]{auto.correlate}}, 
\code{\link[EGAnet]{network.estimation}},
\code{\link[EGAnet]{community.detection}},
\code{\link[EGAnet]{community.consensus}}, and
\code{\link[EGAnet]{EGA}}}
}
\value{
Returns a list containing:

\item{EGA}{Results from \code{\link[EGAnet]{EGA}}}

\item{RI}{A list containing information about the random-intercept
model (if the model converged):

\itemize{

\item \code{fit} --- The fit object for the random-intercept model using \code{\link[lavaan]{cfa}}

\item \code{lavaan.args} --- The arguments used in \code{\link[lavaan]{cfa}}

\item \code{loadings} --- Standardized loadings from the random-intercept model

\item \code{correlation} --- Residual correlations after accounting for the random-intercept model

}

}

\item{TEFI}{\code{link[EGAnet]{tefi}} for the estimated structure}

\item{plot.EGA}{Plot output if \code{plot.EGA = TRUE}}
}
\description{
Estimates the number of substantive dimensions after controlling 
for wording effects. EGA is applied to a residual correlation matrix after 
subtracting and random intercept factor with equal unstandardized loadings 
from all the regular and unrecoded reversed items in the database
}
\examples{
# Obtain example data
wmt <- wmt2[,7:24]

# riEGA example
riEGA(data = wmt, plot.EGA = FALSE)
# no plot for CRAN checks

}
\references{
\strong{Selection of CFA Estimator} \cr
Rhemtulla, M., Brosseau-Liard, P. E., & Savalei, V. (2012).
When can categorical variables be treated as continuous? A comparison of robust continuous and categorical SEM estimation methods under suboptimal conditions.
\emph{Psychological Methods}, \emph{17}, 354-373.
}
\seealso{
\code{\link[EGAnet]{plot.EGAnet}} for plot usage in \code{\link{EGAnet}}
}
\author{
Alejandro Garcia-Pardina <alejandrogp97@gmail.com>,
Francisco J. Abad <fjose.abad@uam.es>,
Alexander P. Christensen <alexpaulchristensen@gmail.com>,
Hudson Golino <hfg9s at virginia.edu>,
Luis Eduardo Garrido <luisgarrido@pucmm.edu.do>, and
Robert Moulder <rgm4fd@virginia.edu>
}
