% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LCT.R
\name{LCT}
\alias{LCT}
\title{Loadings Comparison Test}
\usage{
LCT(
  data,
  n,
  iter = 100,
  dynamic = FALSE,
  dynamic.args = list(n.embed = 4, tau = 1, delta = 1, use.derivatives = 1)
)
}
\arguments{
\item{data}{Matrix or data frame.
A data frame with the variables to be used in the test or a correlation matrix.
If the data used is a correlation matrix, the argument \code{n} will need to be specified}

\item{n}{Integer.
Sample size (if the data provided is a correlation matrix)}

\item{iter}{Integer.
Number of replicate samples to be drawn from a multivariate
normal distribution (uses \code{mvtnorm::mvrnorm}).
Defaults to \code{100}}

\item{dynamic}{Boolean.
Is the dataset a time series where rows are time points and
columns are variables?
Defaults to \code{FASLE}.}

\item{dynamic.args}{List.
Arguments to be used in \code{\link[EGAnet]{dynEGA}}.
Defaults:

\itemize{

\item{\code{n.embed}}
{Number of embeddings: 4}

\item{\code{tau}}
{Lag: 1}

\item{\code{delta}}
{Delta: 1}

\item{\code{use.derivatives}}
{Derivatives: 1}

}}
}
\value{
Returns a list containing:

\item{empirical}{Prediction of model based on empirical dataset only}

\item{bootstrap}{Prediction of model based on means of the loadings across
the bootstrap replicate samples}

\item{proportion}{Proportions of models suggested across bootstraps}
}
\description{
An algorithm to identify whether data were generated from a
factor or network model using factor and network loadings.
The algorithm uses heuristics based on theory and simulation. These
heuristics were then submitted to several deep learning neural networks
with 240,000 samples per model with varying parameters.
}
\examples{
\donttest{# Compute LCT
## Network model
LCT(data = wmt2[,7:24])

## Factor model
LCT(data = psychTools::bfi[,1:25])

# Dynamic LCT
LCT(sim.dynEGA[sim.dynEGA$ID == 1,1:20], dynamic = TRUE)}


}
\references{
Christensen, A. P., & Golino, H. (2021).
Factor or network model? Predictions from neural networks.
\emph{Journal of Behavioral Data Science}, \emph{1}(1), 85-126.
}
\author{
Hudson F. Golino <hfg9s at virginia.edu> and Alexander P. Christensen <alexpaulchristensen at gmail.com>
}
