% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.redundant.combine.R
\name{node.redundant.combine}
\alias{node.redundant.combine}
\title{Combines Redundant Nodes}
\usage{
node.redundant.combine(
  node.redundant.obj,
  type = c("sum", "latent"),
  estimator = "WLSMV",
  auto = FALSE,
  ...
)
}
\arguments{
\item{node.redundant.obj}{A \code{\link[EGAnet]{node.redundant}} object}

\item{type}{Character.
Method to use to combine redundant variables.

\itemize{
\item{\code{"sum"}}
{Computes sum scores (i.e., means) of the variables}

\item{\code{"latent"}}
{Computes latent variable scores using \code{[lavaan]{cfa}}}
}

Defaults to \code{"latent"}}

\item{estimator}{Character.
Estimator to use for latent variables.
Defaults to \code{"WLSMV"}.
See \code{[lavaan]{cfa}} for more options}

\item{auto}{NOT RECOMMENDED. Boolean.
Should redundant nodes be automatically combined?
Defaults to \code{FALSE}.
If set to \code{TRUE}, then redundant nodes will combined using
the following heuristics:

1. Redundant nodes that form a 3-clique (i.e., a triangle)
with the target node are automatically redundant

2. If there are no 3-cliques, then the 2-clique with the
largest regularized partial correlation is selected}

\item{...}{Options to be passed onto \code{[lavaan]{cfa}}}
}
\value{
Returns a list:

\item{data}{New data with redundant variables merged}

\item{merged}{A matrix containing the variables that were
decided to be redundant with one another}
}
\description{
Allows user to combine redundant nodes into
sum scores and latent variables to reduce the redundancy of
variables in their data
}
\examples{
# obtain SAPA items
items <- psychTools::spi[,-c(1:10)]

\donttest{
# weighted topological overlap
redund <- node.redundant(items, method = "wTO", type = "adapt")

# partial correlation
redund <- node.redundant(items, method = "pcor", type = "adapt")

# check redundancies
key.ind <- match(colnames(items), as.character(psychTools::spi.dictionary$item_id))
key <- as.character(psychTools::spi.dictionary$item[key.ind])

# change names in redundancy output to questionnaire item description
named.nr <- node.redundant.names(redund, key)
}

if(interactive())
{combine <- node.redundant.combine(named.nr)}

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
